/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.inventory;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import li.cil.scannable.common.capabilities.Capabilities;
import li.cil.scannable.common.item.ScannerModuleItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public final class ScannerItemHandler
extends ItemStackHandler {
    private static final int ACTIVE_MODULE_COUNT = 3;
    private static final int INACTIVE_MODULE_COUNT = 6;
    private static final int TOTAL_MODULE_COUNT = 9;
    private static final String TAG_ITEMS = "items";
    private final ItemStack container;

    public ScannerItemHandler(ItemStack container) {
        super(9);
        this.container = container;
    }

    public void updateFromNBT() {
        CompoundTag tag = this.container.m_41783_();
        if (tag != null && tag.m_128425_(TAG_ITEMS, 10)) {
            this.deserializeNBT(tag.m_128469_(TAG_ITEMS));
            if (this.stacks.size() != 9) {
                ArrayList oldStacks = new ArrayList(this.stacks);
                this.setSize(9);
                int count = Math.min(9, oldStacks.size());
                for (int slot = 0; slot < count; ++slot) {
                    this.stacks.set(slot, (Object)((ItemStack)oldStacks.get(slot)));
                }
            }
        }
    }

    public IItemHandler getActiveModules() {
        return new RangedWrapper((IItemHandlerModifiable)this, 0, 3);
    }

    public IItemHandler getInactiveModules() {
        return new RangedWrapper((IItemHandlerModifiable)this, 3, 9);
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_41720_() instanceof ScannerModuleItem) {
            return 64;
        }
        LazyOptional module = stack.getCapability(Capabilities.SCANNER_MODULE_CAPABILITY);
        if (module.isPresent()) {
            return 64;
        }
        return 0;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.container.m_41700_(TAG_ITEMS, (Tag)this.serializeNBT());
    }
}

