/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.energy;

import li.cil.scannable.common.config.CommonConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.EnergyStorage;

public final class ScannerEnergyStorage
extends EnergyStorage {
    private static final String TAG_ENERGY = "energy";
    private final ItemStack container;

    public static ScannerEnergyStorage of(ItemStack stack) {
        ScannerEnergyStorage energyStorage = new ScannerEnergyStorage(stack);
        energyStorage.updateFromNBT();
        return energyStorage;
    }

    public ScannerEnergyStorage(ItemStack container) {
        super(CommonConfig.energyCapacityScanner);
        this.container = container;
    }

    public void updateFromNBT() {
        CompoundTag tag = this.container.m_41783_();
        if (tag != null && tag.m_128425_(TAG_ENERGY, 3)) {
            this.deserializeNBT(tag.m_128423_(TAG_ENERGY));
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!CommonConfig.useEnergy) {
            return 0;
        }
        int energyReceived = super.receiveEnergy(maxReceive, simulate);
        if (!simulate && energyReceived != 0) {
            this.container.m_41700_(TAG_ENERGY, this.serializeNBT());
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!CommonConfig.useEnergy) {
            return 0;
        }
        int energyExtracted = super.extractEnergy(maxExtract, simulate);
        if (!simulate && energyExtracted != 0) {
            this.container.m_41700_(TAG_ENERGY, this.serializeNBT());
        }
        return energyExtracted;
    }
}

