/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.config;

import java.util.HashSet;
import java.util.Set;
import li.cil.scannable.util.ConfigManager;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public final class CommonConfig {
    @ConfigManager.Path(value="energy")
    @ConfigManager.WorldRestart
    @ConfigManager.Comment(value={"Whether to consume energy when performing a scan. Will make the scanner a chargeable item."})
    public static boolean useEnergy = true;
    @ConfigManager.Path(value="energy")
    @ConfigManager.WorldRestart
    @ConfigManager.Min(value=0.0)
    @ConfigManager.Comment(value={"Amount of energy that can be stored in a scanner."})
    public static int energyCapacityScanner = 5000;
    @ConfigManager.Path(value="energy")
    @ConfigManager.WorldRestart
    @ConfigManager.Min(value=0.0)
    @ConfigManager.Comment(value={"Amount of energy used by the range module per scan."})
    public static int energyCostModuleRange = 100;
    @ConfigManager.Path(value="energy")
    @ConfigManager.WorldRestart
    @ConfigManager.Min(value=0.0)
    @ConfigManager.Comment(value={"Amount of energy used by the animal module per scan."})
    public static int energyCostModuleAnimal = 25;
    @ConfigManager.Path(value="energy")
    @ConfigManager.WorldRestart
    @ConfigManager.Min(value=0.0)
    @ConfigManager.Comment(value={"Amount of energy used by the monster module per scan."})
    public static int energyCostModuleMonster = 50;
    @ConfigManager.Path(value="energy")
    @ConfigManager.WorldRestart
    @ConfigManager.Min(value=0.0)
    @ConfigManager.Comment(value={"Amount of energy used by the common ore module per scan."})
    public static int energyCostModuleOreCommon = 75;
    @ConfigManager.Path(value="energy")
    @ConfigManager.WorldRestart
    @ConfigManager.Min(value=0.0)
    @ConfigManager.Comment(value={"Amount of energy used by the rare ore module per scan."})
    public static int energyCostModuleOreRare = 100;
    @ConfigManager.Path(value="energy")
    @ConfigManager.WorldRestart
    @ConfigManager.Min(value=0.0)
    @ConfigManager.Comment(value={"Amount of energy used by the block module per scan."})
    public static int energyCostModuleBlock = 100;
    @ConfigManager.Path(value="energy")
    @ConfigManager.WorldRestart
    @ConfigManager.Min(value=0.0)
    @ConfigManager.Comment(value={"Amount of energy used by the fluid module per scan."})
    public static int energyCostModuleFluid = 50;
    @ConfigManager.Path(value="energy")
    @ConfigManager.WorldRestart
    @ConfigManager.Min(value=0.0)
    @ConfigManager.Comment(value={"Amount of energy used by the entity module per scan."})
    public static int energyCostModuleEntity = 75;
    @ConfigManager.Path(value="general")
    @ConfigManager.WorldRestart
    @ConfigManager.Min(value=16.0)
    @ConfigManager.Max(value=128.0)
    @ConfigManager.Comment(value={"The basic scan radius without range modules. Higher values mean more computational\noverhead and thus potentially worse performance while scanning.\nIMPORTANT: some modules such as the block and ore scanner modules will already use\na reduced radius based on this value. Specifically, the ore scanners multiply this\nvalue by 0.25, and the block scanner multiplies it by 0.5.\nRange modules will boost the range by half this value."})
    public static int baseScanRadius = 64;
    @ConfigManager.Path(value="general")
    @ConfigManager.WorldRestart
    @ConfigManager.Min(value=1000.0)
    @ConfigManager.Max(value=300000.0)
    @ConfigManager.Comment(value={"How long the results from a scan should remain visible, in milliseconds."})
    public static int scanStayDuration = 10000;
    @ConfigManager.Path(value="blocks")
    @ConfigManager.WorldRestart
    @ConfigManager.Comment(value={"Registry names of blocks that should be ignored.\nBlocks in this list will be excluded from the default ore list based on the forge:ores\ntag and it will be impossible to tune the entity module to this block."})
    @ConfigManager.ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> ignoredBlocks = (Set)Util.m_137469_(new HashSet(), c -> c.add(Blocks.f_50272_.getRegistryName()));
    @ConfigManager.Path(value="blocks")
    @ConfigManager.WorldRestart
    @ConfigManager.Comment(value={"Tag names of block tags that should be ignored.\nBlocks matching a tag in this list will be excluded from the default ore list based on the\nforge:ores tag and it will be impossible to tune the entity module to this block."})
    @ConfigManager.ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> ignoredBlockTags = new HashSet<ResourceLocation>();
    @ConfigManager.Path(value="ores")
    @ConfigManager.WorldRestart
    @ConfigManager.Comment(value={"Registry names of blocks considered 'common ores', requiring the common ore scanner module."})
    @ConfigManager.ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> commonOreBlocks = (Set)Util.m_137469_(new HashSet(), c -> c.add(Blocks.f_50129_.getRegistryName()));
    @ConfigManager.Path(value="ores")
    @ConfigManager.WorldRestart
    @ConfigManager.Comment(value={"Block tags of blocks considered 'common ores', requiring the common ore scanner module."})
    @ConfigManager.ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> commonOreBlockTags = (Set)Util.m_137469_(new HashSet(), c -> {
        c.add(Tags.Blocks.ORES_COAL.m_6979_());
        c.add(Tags.Blocks.ORES_IRON.m_6979_());
        c.add(Tags.Blocks.ORES_REDSTONE.m_6979_());
        c.add(Tags.Blocks.ORES_QUARTZ.m_6979_());
        c.add(new ResourceLocation("forge", "ores/copper"));
        c.add(new ResourceLocation("forge", "ores/tin"));
    });
    @ConfigManager.Path(value="ores")
    @ConfigManager.WorldRestart
    @ConfigManager.Comment(value={"Registry names of blocks considered 'rare ores', requiring the rare ore scanner module."})
    @ConfigManager.ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> rareOreBlocks = (Set)Util.m_137469_(new HashSet(), c -> c.add(Blocks.f_50141_.getRegistryName()));
    @ConfigManager.Path(value="ores")
    @ConfigManager.WorldRestart
    @ConfigManager.Comment(value={"Block tags of blocks considered 'rare ores', requiring the common ore scanner module.\nAny block with the forge:ores tag is implicitly in this list, unless the block also\nmatches an ignored or common ore block tag, or is an ignored or common block."})
    @ConfigManager.ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> rareOreBlockTags = new HashSet<ResourceLocation>();
    @ConfigManager.Path(value="fluids")
    @ConfigManager.WorldRestart
    @ConfigManager.Comment(value={"Fluid tags of fluids that should be ignored."})
    @ConfigManager.ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> ignoredFluidTags = new HashSet<ResourceLocation>();
}

