/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.scanning;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import li.cil.scannable.api.API;
import li.cil.scannable.api.prefab.AbstractScanResultProvider;
import li.cil.scannable.api.scanning.BlockScannerModule;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.client.ClientConfig;
import li.cil.scannable.client.shader.Shaders;
import li.cil.scannable.common.capabilities.Capabilities;
import li.cil.scannable.common.scanning.filter.IgnoredBlocks;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public final class ScanResultProviderBlock
extends AbstractScanResultProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_RESULTS_PER_BLOCK = 8192;
    private static final int DEFAULT_COLOR = 0x4466CC;
    private final List<ScanFilterLayer> scanFilterLayers = new ArrayList<ScanFilterLayer>();
    private final List<ChunkSectionPos> pendingChunkSections = new ArrayList<ChunkSectionPos>();
    private int currentChunkSection;
    private int chunkSectionsPerTick;
    private final Map<Block, Map<BlockPos, BlockScanResult>> resultClusters = new HashMap<Block, Map<BlockPos, BlockScanResult>>();
    private final List<BlockScanResult> results = new ArrayList<BlockScanResult>();
    private long renderStartTime;

    @Override
    public void initialize(Player player, Collection<ItemStack> modules, Vec3 center, float radius, int scanTicks) {
        super.initialize(player, modules, center, radius, scanTicks);
        this.scanFilterLayers.clear();
        IntObjectHashMap filterByRadius = new IntObjectHashMap();
        for (ItemStack stack : modules) {
            LazyOptional capability = stack.getCapability(Capabilities.SCANNER_MODULE_CAPABILITY);
            capability.ifPresent(arg_0 -> this.lambda$initialize$1(stack, (IntObjectMap)filterByRadius, arg_0));
        }
        IntArrayList scanFilterKeys = new IntArrayList();
        scanFilterKeys.addAll((Collection)filterByRadius.keySet());
        scanFilterKeys.sort((a, b) -> -Integer.compare(a, b));
        if (scanFilterKeys.size() > 0) {
            ItemStack stack;
            this.radius = scanFilterKeys.getInt(0);
            stack = scanFilterKeys.iterator();
            while (stack.hasNext()) {
                int r = (Integer)stack.next();
                this.scanFilterLayers.add(new ScanFilterLayer(r, (List)filterByRadius.get(r)));
            }
            BlockPos minBlockPos = new BlockPos(center).m_142022_((double)(-this.radius), (double)(-this.radius), (double)(-this.radius));
            BlockPos maxBlockPos = new BlockPos(center).m_142022_((double)this.radius, (double)this.radius, (double)this.radius);
            ChunkPos minChunkPos = new ChunkPos(minBlockPos);
            ChunkPos maxChunkPos = new ChunkPos(maxBlockPos);
            int minChunkSectionIndex = Math.max(player.m_183503_().m_151564_(minBlockPos.m_123342_()), 0);
            int maxChunkSectionIndex = Math.min(player.m_183503_().m_151564_(maxBlockPos.m_123342_()), player.m_183503_().m_151559_() - 1);
            for (int chunkSectionIndex = minChunkSectionIndex; chunkSectionIndex <= maxChunkSectionIndex; ++chunkSectionIndex) {
                for (int chunkZ = minChunkPos.f_45579_; chunkZ <= maxChunkPos.f_45579_; ++chunkZ) {
                    for (int chunkX = minChunkPos.f_45578_; chunkX <= maxChunkPos.f_45578_; ++chunkX) {
                        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                        int chunkY = player.m_183503_().m_151568_(chunkSectionIndex);
                        double dx = Math.min(Math.abs((double)chunkPos.m_45604_() - center.f_82479_), Math.abs((double)chunkPos.m_45608_() - center.f_82479_));
                        double dz = Math.min(Math.abs((double)chunkPos.m_45605_() - center.f_82481_), Math.abs((double)chunkPos.m_45609_() - center.f_82481_));
                        double dy = Math.min(Math.abs((double)SectionPos.m_175554_((int)chunkY, (int)0) - center.f_82480_), Math.abs((double)SectionPos.m_175554_((int)chunkY, (int)15) - center.f_82480_));
                        double squareDistToCenter = dx * dx + dy * dy + dz * dz;
                        if (squareDistToCenter > (double)(radius * radius)) continue;
                        this.pendingChunkSections.add(new ChunkSectionPos(chunkX, chunkZ, chunkSectionIndex, squareDistToCenter));
                    }
                }
            }
            this.pendingChunkSections.sort(Comparator.comparingDouble(p -> p.squareDistToCenter));
            this.chunkSectionsPerTick = Mth.m_14167_((float)((float)this.pendingChunkSections.size() / (float)scanTicks));
            this.currentChunkSection = 0;
        }
    }

    @Override
    public void computeScanResults() {
        Level level = this.player.f_19853_;
        for (int i = 0; i < this.chunkSectionsPerTick; ++i) {
            LevelChunkSection[] sections;
            LevelChunkSection section;
            if (this.currentChunkSection >= this.pendingChunkSections.size()) {
                return;
            }
            ChunkSectionPos chunkSectionPos = this.pendingChunkSections.get(this.currentChunkSection);
            ++this.currentChunkSection;
            int chunkX = chunkSectionPos.chunkX;
            int chunkZ = chunkSectionPos.chunkZ;
            int chunkSectionIndex = chunkSectionPos.chunkSectionIndex;
            ChunkAccess chunk = level.m_6522_(chunkX, chunkZ, ChunkStatus.f_62326_, false);
            if (chunk == null || (section = (sections = chunk.m_7103_())[chunkSectionIndex]) == null || section.m_188008_()) continue;
            PalettedContainer palette = section.m_63019_();
            BlockPos origin = chunk.m_7697_().m_45615_().m_142082_(0, section.m_63017_(), 0);
            int originX = origin.m_123341_();
            int originY = origin.m_123342_();
            int originZ = origin.m_123343_();
            block1: for (int index = 0; index < 4096; ++index) {
                BlockState state = (BlockState)palette.m_63085_(index);
                Block block = state.m_60734_();
                Map clusters = this.resultClusters.computeIfAbsent(block, b -> new HashMap());
                if (clusters.size() > 8192 || IgnoredBlocks.contains(state)) continue;
                int x = index & 0xF;
                int z = index >> 4 & 0xF;
                int y = index >> 8 & 0xF;
                int globalX = originX + x;
                int globalY = originY + y;
                int globalZ = originZ + z;
                double squaredDistance = this.center.m_82531_((double)globalX + 0.5, (double)globalY + 0.5, (double)globalZ + 0.5);
                for (ScanFilterLayer layer : this.scanFilterLayers) {
                    if (squaredDistance > (double)(layer.radius * layer.radius)) continue block1;
                    for (Predicate<BlockState> filter : layer.filters) {
                        if (!filter.test(state)) continue;
                        BlockPos pos = new BlockPos(globalX, globalY, globalZ);
                        if (this.tryAddToCluster(clusters, pos)) continue block1;
                        BlockScanResult result = new BlockScanResult(state.m_60734_(), pos);
                        clusters.put(pos, result);
                        this.results.add(result);
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    public void collectScanResults(BlockGetter level, Consumer<ScanResult> callback) {
        for (BlockScanResult result : this.results) {
            if (!result.isRoot()) continue;
            result.bake(level);
            callback.accept(result);
        }
        this.renderStartTime = System.currentTimeMillis();
    }

    @Override
    public void render(MultiBufferSource bufferSource, PoseStack poseStack, Camera renderInfo, float partialTicks, List<ScanResult> results) {
        ShaderInstance shader = Shaders.getScanResultShader();
        if (shader == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91063_.f_109070_) {
            Matrix4f oldProjectionMatrix = RenderSystem.m_157192_();
            RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            poseStack.m_85836_();
            try {
                Minecraft.m_91087_().f_91063_.m_109120_(poseStack, renderInfo, partialTicks);
            }
            catch (Throwable e) {
                LOGGER.catching(e);
            }
            poseStack.m_85849_();
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.m_157425_((Matrix4f)oldProjectionMatrix);
        }
        shader.m_173356_("time").m_5985_((float)(System.currentTimeMillis() - this.renderStartTime) / 1000.0f);
        RenderType renderType = ScanResultProviderBlock.getBlockScanResultRenderLayer();
        renderType.m_110185_();
        for (ScanResult result2 : results) {
            BlockScanResult blockResult = (BlockScanResult)result2;
            VertexBuffer vbo = blockResult.vbo;
            vbo.m_166867_(poseStack.m_85850_().m_85861_(), RenderSystem.m_157192_(), shader);
            VertexBuffer.m_85931_();
        }
        renderType.m_110188_();
        Vec3 lookVec = new Vec3(renderInfo.m_90596_());
        Vec3 viewerEyes = renderInfo.m_90583_();
        float yaw = renderInfo.m_90590_();
        float pitch = renderInfo.m_90589_();
        boolean showDistance = renderInfo.m_90592_().m_6144_();
        results.sort(Comparator.comparing(result -> {
            BlockScanResult blockResult = (BlockScanResult)result;
            Vec3 resultPos = blockResult.getPosition();
            Vec3 toResult = resultPos.m_82546_(viewerEyes);
            return lookVec.m_82526_(toResult.m_82541_());
        }));
        for (ScanResult result3 : results) {
            BlockScanResult blockResult = (BlockScanResult)result3;
            Vec3 resultPos = result3.getPosition();
            Vec3 toResult = resultPos.m_82546_(viewerEyes);
            float lookDirDot = (float)lookVec.m_82526_(toResult.m_82541_());
            Block block = blockResult.block;
            MutableComponent label = block.m_49954_();
            if (!(lookDirDot > 0.98f) || Strings.isNullOrEmpty((String)label.getString())) continue;
            float distance = showDistance ? (float)resultPos.m_82546_(viewerEyes).m_82553_() : 0.0f;
            ScanResultProviderBlock.renderIconLabel(bufferSource, poseStack, yaw, pitch, lookVec, viewerEyes, distance, resultPos, API.ICON_INFO, (Component)label);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.scanFilterLayers.clear();
        this.chunkSectionsPerTick = 0;
        this.currentChunkSection = 0;
        this.pendingChunkSections.clear();
        this.resultClusters.clear();
        this.results.clear();
    }

    public static RenderType getBlockScanResultRenderLayer() {
        return RenderType.m_173215_((String)"scan_result", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)65536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(Shaders::getScanResultShader)).m_110685_(RenderStateShard.f_110136_).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110691_(false));
    }

    private boolean tryAddToCluster(Map<BlockPos, BlockScanResult> clusters, BlockPos pos) {
        BlockScanResult root = null;
        root = this.tryAddToCluster(clusters, pos, pos.m_142126_(), root);
        root = this.tryAddToCluster(clusters, pos, pos.m_142125_(), root);
        root = this.tryAddToCluster(clusters, pos, pos.m_142127_(), root);
        root = this.tryAddToCluster(clusters, pos, pos.m_142128_(), root);
        root = this.tryAddToCluster(clusters, pos, pos.m_7494_(), root);
        root = this.tryAddToCluster(clusters, pos, pos.m_7495_(), root);
        return root != null;
    }

    @Nullable
    private BlockScanResult tryAddToCluster(Map<BlockPos, BlockScanResult> clusters, BlockPos pos, BlockPos clusterPos, @Nullable BlockScanResult root) {
        BlockScanResult cluster = clusters.get(clusterPos);
        if (cluster == null) {
            return root;
        }
        if (root == null) {
            root = cluster.getRoot();
            root.add(pos);
            clusters.put(pos, root);
        } else {
            cluster.getRoot().setRoot(root);
        }
        return root;
    }

    private /* synthetic */ void lambda$initialize$1(ItemStack stack, IntObjectMap filterByRadius, ScannerModule module) {
        if (module instanceof BlockScannerModule) {
            BlockScannerModule blockModule = (BlockScannerModule)module;
            Predicate<BlockState> filter = blockModule.getFilter(stack);
            int localRadius = (int)Math.ceil(blockModule.adjustLocalRange(this.radius));
            ((List)filterByRadius.computeIfAbsent((Object)localRadius, r -> new ArrayList())).add(filter);
        }
    }

    private record ScanFilterLayer(int radius, List<Predicate<BlockState>> filters) {
    }

    private record ChunkSectionPos(int chunkX, int chunkZ, int chunkSectionIndex, double squareDistToCenter) {
    }

    private static final class BlockScanResult
    implements ScanResult {
        private final Block block;
        private AABB bounds;
        @Nullable
        private BlockScanResult parent;
        private final Set<BlockPos> blocks;
        private int color;
        private VertexBuffer vbo;

        BlockScanResult(Block block, BlockPos pos) {
            this.block = block;
            this.bounds = new AABB(pos);
            this.blocks = new HashSet<BlockPos>();
            this.blocks.add(pos);
        }

        void bake(BlockGetter level) {
            BlockState blockState = this.block.m_49966_();
            this.color = blockState.m_60780_((BlockGetter)level, (BlockPos)new BlockPos((Vec3)this.bounds.m_82399_())).f_76396_;
            FluidState fluidState = blockState.m_60819_();
            if (!fluidState.m_76178_()) {
                if (ClientConfig.fluidColors.containsKey((Object)fluidState.m_76152_().getRegistryName())) {
                    this.color = ClientConfig.fluidColors.getInt((Object)fluidState.m_76152_().getRegistryName());
                } else {
                    ClientConfig.fluidTagColors.forEach((k, v) -> {
                        Tag tag = FluidTags.m_144299_().m_13404_(k);
                        if (tag != null && tag.m_8110_((Object)fluidState.m_76152_())) {
                            this.color = v;
                        }
                    });
                }
            } else if (ClientConfig.blockColors.containsKey((Object)blockState.m_60734_().getRegistryName())) {
                this.color = ClientConfig.blockColors.getInt((Object)blockState.m_60734_().getRegistryName());
            } else {
                ClientConfig.blockTagColors.forEach((k, v) -> {
                    Tag tag = BlockTags.m_13115_().m_13404_(k);
                    if (tag != null && tag.m_8110_((Object)blockState.m_60734_())) {
                        this.color = v;
                    }
                });
            }
            if (this.color == 0) {
                this.color = 0x4466CC;
            }
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            this.render((VertexConsumer)buffer, new PoseStack());
            buffer.m_85721_();
            this.vbo = new VertexBuffer();
            this.vbo.m_85925_(buffer);
        }

        boolean isRoot() {
            return this.parent == null;
        }

        BlockScanResult getRoot() {
            if (this.parent != null) {
                return this.parent.getRoot();
            }
            return this;
        }

        void setRoot(BlockScanResult root) {
            if (root == this) {
                return;
            }
            assert (this.parent == null);
            root.bounds = root.bounds.m_82367_(this.bounds);
            root.blocks.addAll(this.blocks);
            this.blocks.clear();
            this.parent = root;
        }

        void add(BlockPos pos) {
            assert (this.parent == null) : "Trying to add to non-root node.";
            this.bounds = this.bounds.m_82367_(new AABB(pos));
            this.blocks.add(pos);
        }

        void render(VertexConsumer buffer, PoseStack poseStack) {
            Matrix4f matrix = poseStack.m_85850_().m_85861_();
            float colorNormalizer = 0.003921569f;
            float r = (float)(this.color >> 16 & 0xFF) * 0.003921569f;
            float g = (float)(this.color >> 8 & 0xFF) * 0.003921569f;
            float b = (float)(this.color & 0xFF) * 0.003921569f;
            float sizeUvX = (float)(1.0 / this.bounds.m_82362_());
            float sizeUvY = (float)(1.0 / this.bounds.m_82376_());
            float sizeUvZ = (float)(1.0 / this.bounds.m_82385_());
            for (BlockPos cell : this.blocks) {
                float maxY;
                float minY;
                float z;
                float maxX;
                float minX;
                float y;
                float v1;
                float v0;
                float u1;
                float u0;
                float maxZ;
                float minZ;
                float maxY2;
                float minY2;
                float x;
                if (!this.blocks.contains(cell.m_142082_(-1, 0, 0))) {
                    x = cell.m_123341_();
                    minY2 = cell.m_123342_();
                    maxY2 = cell.m_123342_() + 1;
                    minZ = cell.m_123343_();
                    maxZ = cell.m_123343_() + 1;
                    u0 = (minY2 - (float)this.bounds.f_82289_) * sizeUvY;
                    u1 = u0 + sizeUvY;
                    v0 = (minZ - (float)this.bounds.f_82290_) * sizeUvZ;
                    v1 = v0 + sizeUvZ;
                    buffer.m_85982_(matrix, x, minY2, minZ).m_7421_(u0, v0).m_85950_(r, g, b, 0.8f).m_5752_();
                    buffer.m_85982_(matrix, x, minY2, maxZ).m_7421_(u0, v1).m_85950_(r, g, b, 0.8f).m_5752_();
                    buffer.m_85982_(matrix, x, maxY2, maxZ).m_7421_(u1, v1).m_85950_(r, g, b, 0.8f).m_5752_();
                    buffer.m_85982_(matrix, x, maxY2, minZ).m_7421_(u1, v0).m_85950_(r, g, b, 0.8f).m_5752_();
                }
                if (!this.blocks.contains(cell.m_142082_(1, 0, 0))) {
                    x = cell.m_123341_() + 1;
                    minY2 = cell.m_123342_();
                    maxY2 = cell.m_123342_() + 1;
                    minZ = cell.m_123343_();
                    maxZ = cell.m_123343_() + 1;
                    u0 = (minY2 - (float)this.bounds.f_82289_) * sizeUvY;
                    u1 = u0 + sizeUvY;
                    v0 = (minZ - (float)this.bounds.f_82290_) * sizeUvZ;
                    v1 = v0 + sizeUvZ;
                    buffer.m_85982_(matrix, x, minY2, minZ).m_7421_(u0, v0).m_85950_(r, g, b, 0.8f).m_5752_();
                    buffer.m_85982_(matrix, x, maxY2, minZ).m_7421_(u1, v0).m_85950_(r, g, b, 0.8f).m_5752_();
                    buffer.m_85982_(matrix, x, maxY2, maxZ).m_7421_(u1, v1).m_85950_(r, g, b, 0.8f).m_5752_();
                    buffer.m_85982_(matrix, x, minY2, maxZ).m_7421_(u0, v1).m_85950_(r, g, b, 0.8f).m_5752_();
                }
                if (!this.blocks.contains(cell.m_142082_(0, -1, 0))) {
                    y = cell.m_123342_();
                    minX = cell.m_123341_();
                    maxX = cell.m_123341_() + 1;
                    minZ = cell.m_123343_();
                    maxZ = cell.m_123343_() + 1;
                    u0 = (minX - (float)this.bounds.f_82288_) * sizeUvX;
                    u1 = u0 + sizeUvX;
                    v0 = (minZ - (float)this.bounds.f_82290_) * sizeUvZ;
                    v1 = v0 + sizeUvZ;
                    buffer.m_85982_(matrix, minX, y, minZ).m_7421_(u0, v0).m_85950_(r, g, b, 0.7f).m_5752_();
                    buffer.m_85982_(matrix, maxX, y, minZ).m_7421_(u1, v0).m_85950_(r, g, b, 0.7f).m_5752_();
                    buffer.m_85982_(matrix, maxX, y, maxZ).m_7421_(u1, v1).m_85950_(r, g, b, 0.7f).m_5752_();
                    buffer.m_85982_(matrix, minX, y, maxZ).m_7421_(u0, v1).m_85950_(r, g, b, 0.7f).m_5752_();
                }
                if (!this.blocks.contains(cell.m_142082_(0, 1, 0))) {
                    y = cell.m_123342_() + 1;
                    minX = cell.m_123341_();
                    maxX = cell.m_123341_() + 1;
                    minZ = cell.m_123343_();
                    maxZ = cell.m_123343_() + 1;
                    u0 = (minX - (float)this.bounds.f_82288_) * sizeUvX;
                    u1 = u0 + sizeUvX;
                    v0 = (minZ - (float)this.bounds.f_82290_) * sizeUvZ;
                    v1 = v0 + sizeUvZ;
                    buffer.m_85982_(matrix, minX, y, minZ).m_7421_(u0, v0).m_85950_(r, g, b, 1.0f).m_5752_();
                    buffer.m_85982_(matrix, minX, y, maxZ).m_7421_(u0, v1).m_85950_(r, g, b, 1.0f).m_5752_();
                    buffer.m_85982_(matrix, maxX, y, maxZ).m_7421_(u1, v1).m_85950_(r, g, b, 1.0f).m_5752_();
                    buffer.m_85982_(matrix, maxX, y, minZ).m_7421_(u1, v0).m_85950_(r, g, b, 1.0f).m_5752_();
                }
                if (!this.blocks.contains(cell.m_142082_(0, 0, -1))) {
                    z = cell.m_123343_();
                    minX = cell.m_123341_();
                    maxX = cell.m_123341_() + 1;
                    minY = cell.m_123342_();
                    maxY = cell.m_123342_() + 1;
                    u0 = (minX - (float)this.bounds.f_82288_) * sizeUvX;
                    u1 = u0 + sizeUvX;
                    v0 = (minY - (float)this.bounds.f_82289_) * sizeUvY;
                    v1 = v0 + sizeUvY;
                    buffer.m_85982_(matrix, minX, minY, z).m_7421_(u0, v0).m_85950_(r, g, b, 0.9f).m_5752_();
                    buffer.m_85982_(matrix, minX, maxY, z).m_7421_(u0, v1).m_85950_(r, g, b, 0.9f).m_5752_();
                    buffer.m_85982_(matrix, maxX, maxY, z).m_7421_(u1, v1).m_85950_(r, g, b, 0.9f).m_5752_();
                    buffer.m_85982_(matrix, maxX, minY, z).m_7421_(u1, v0).m_85950_(r, g, b, 0.9f).m_5752_();
                }
                if (this.blocks.contains(cell.m_142082_(0, 0, 1))) continue;
                z = cell.m_123343_() + 1;
                minX = cell.m_123341_();
                maxX = cell.m_123341_() + 1;
                minY = cell.m_123342_();
                maxY = cell.m_123342_() + 1;
                u0 = (minX - (float)this.bounds.f_82288_) * sizeUvX;
                u1 = u0 + sizeUvX;
                v0 = (minY - (float)this.bounds.f_82289_) * sizeUvY;
                v1 = v0 + sizeUvY;
                buffer.m_85982_(matrix, minX, minY, z).m_7421_(u0, v0).m_85950_(r, g, b, 0.9f).m_5752_();
                buffer.m_85982_(matrix, maxX, minY, z).m_7421_(u1, v0).m_85950_(r, g, b, 0.9f).m_5752_();
                buffer.m_85982_(matrix, maxX, maxY, z).m_7421_(u1, v1).m_85950_(r, g, b, 0.9f).m_5752_();
                buffer.m_85982_(matrix, minX, maxY, z).m_7421_(u0, v1).m_85950_(r, g, b, 0.9f).m_5752_();
            }
        }

        @Override
        @Nullable
        public AABB getRenderBounds() {
            return this.bounds;
        }

        @Override
        public Vec3 getPosition() {
            return this.bounds.m_82399_();
        }

        @Override
        public void close() {
            if (this.vbo != null) {
                this.vbo.close();
                this.vbo = null;
            }
        }
    }
}

