/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.client.renderer.ScannerRenderer;
import li.cil.scannable.common.capabilities.Capabilities;
import li.cil.scannable.common.config.CommonConfig;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;

@OnlyIn(value=Dist.CLIENT)
public final class ScanManager {
    public static final int SCAN_COMPUTE_DURATION = 40;
    private static final int SCAN_INITIAL_RADIUS = 10;
    private static final int SCAN_TIME_OFFSET = 200;
    private static final int SCAN_GROWTH_DURATION = 2000;
    private static final int REFERENCE_RENDER_DISTANCE = 12;
    private static final Set<ScanResultProvider> collectingProviders = new HashSet<ScanResultProvider>();
    private static final Map<ScanResultProvider, List<ScanResult>> collectingResults = new HashMap<ScanResultProvider, List<ScanResult>>();
    private static final Map<ScanResultProvider, List<ScanResult>> pendingResults = new HashMap<ScanResultProvider, List<ScanResult>>();
    private static final Map<ScanResultProvider, List<ScanResult>> renderingResults = new HashMap<ScanResultProvider, List<ScanResult>>();
    private static final List<ScanResult> renderingList = new ArrayList<ScanResult>();
    private static int scanningTicks = -1;
    private static long currentStart = -1L;
    @Nullable
    private static Vec3 lastScanCenter;
    private static PoseStack viewModelStack;
    private static Matrix4f projectionMatrix;

    private static float computeTargetRadius() {
        return Minecraft.m_91087_().f_91063_.m_109152_();
    }

    public static int computeScanGrowthDuration() {
        return 2000 * Minecraft.m_91087_().f_91066_.f_92106_ / 12;
    }

    public static float computeRadius(long start, float duration) {
        float r1 = ScanManager.computeTargetRadius();
        float t1 = duration;
        float b = 200.0f;
        float n = 1.0f / ((t1 + 200.0f) * (t1 + 200.0f) - 40000.0f);
        float a = -r1 * 200.0f * 200.0f * n;
        float c = r1 * n;
        float t = System.currentTimeMillis() - start;
        return 10.0f + a + (t + 200.0f) * (t + 200.0f) * c;
    }

    public static void beginScan(Player player, List<ItemStack> stacks) {
        ScanManager.cancelScan();
        float scanRadius = CommonConfig.baseScanRadius;
        ArrayList modules = new ArrayList();
        for (ItemStack stack : stacks) {
            LazyOptional module = stack.getCapability(Capabilities.SCANNER_MODULE_CAPABILITY);
            module.ifPresent(modules::add);
        }
        for (ScannerModule module : modules) {
            ScanResultProvider provider = module.getResultProvider();
            if (provider != null) {
                collectingProviders.add(provider);
            }
            scanRadius = module.adjustGlobalRange(scanRadius);
        }
        if (collectingProviders.isEmpty()) {
            return;
        }
        Vec3 center = player.m_20182_();
        for (ScanResultProvider provider : collectingProviders) {
            provider.initialize(player, stacks, center, scanRadius, 40);
        }
    }

    public static void updateScan(Entity entity, boolean finish) {
        int remaining = 40 - scanningTicks;
        if (!finish) {
            if (remaining <= 0) {
                return;
            }
            for (ScanResultProvider scanResultProvider : collectingProviders) {
                scanResultProvider.computeScanResults();
            }
            ++scanningTicks;
            return;
        }
        for (int i = 0; i < remaining; ++i) {
            for (ScanResultProvider provider : collectingProviders) {
                provider.computeScanResults();
            }
        }
        for (ScanResultProvider scanResultProvider : collectingProviders) {
            scanResultProvider.collectScanResults((BlockGetter)entity.f_19853_, result -> collectingResults.computeIfAbsent(scanResultProvider, p -> new ArrayList()).add(result));
            scanResultProvider.reset();
        }
        ScanManager.clear();
        lastScanCenter = entity.m_20182_();
        currentStart = System.currentTimeMillis();
        pendingResults.putAll(collectingResults);
        pendingResults.values().forEach(list -> list.sort(Comparator.comparing(result -> -lastScanCenter.m_82554_(result.getPosition()))));
        ScannerRenderer.INSTANCE.ping(lastScanCenter);
        ScanManager.cancelScan();
    }

    public static void cancelScan() {
        collectingProviders.clear();
        collectingResults.clear();
        scanningTicks = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (lastScanCenter == null || currentStart < 0L) {
            return;
        }
        if (CommonConfig.scanStayDuration < (int)(System.currentTimeMillis() - currentStart)) {
            pendingResults.forEach((provider, results) -> results.forEach(ScanResult::close));
            pendingResults.clear();
            Map<ScanResultProvider, List<ScanResult>> map = renderingResults;
            synchronized (map) {
                if (!renderingResults.isEmpty()) {
                    Iterator<Map.Entry<ScanResultProvider, List<ScanResult>>> iterator = renderingResults.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<ScanResultProvider, List<ScanResult>> entry = iterator.next();
                        List<ScanResult> list = entry.getValue();
                        for (int i = Mth.m_14167_((float)((float)list.size() * 0.5f)); i > 0; --i) {
                            list.get(list.size() - 1).close();
                            list.remove(list.size() - 1);
                        }
                        if (!list.isEmpty()) continue;
                        iterator.remove();
                    }
                }
                if (renderingResults.isEmpty()) {
                    ScanManager.clear();
                }
            }
            return;
        }
        if (pendingResults.size() <= 0) {
            return;
        }
        float radius = ScanManager.computeRadius(currentStart, ScanManager.computeScanGrowthDuration());
        float sqRadius = radius * radius;
        Iterator<Map.Entry<ScanResultProvider, List<ScanResult>>> iterator = pendingResults.entrySet().iterator();
        while (iterator.hasNext()) {
            ScanResult result;
            Vec3 position;
            Map.Entry<ScanResultProvider, List<ScanResult>> entry = iterator.next();
            ScanResultProvider provider2 = entry.getKey();
            List<ScanResult> results2 = entry.getValue();
            while (results2.size() > 0 && lastScanCenter.m_82557_(position = (result = results2.get(results2.size() - 1)).getPosition()) <= (double)sqRadius) {
                results2.remove(results2.size() - 1);
                Map<ScanResultProvider, List<ScanResult>> map = renderingResults;
                synchronized (map) {
                    renderingResults.computeIfAbsent(provider2, p -> new ArrayList()).add(result);
                }
            }
            if (results2.size() != 0) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRenderLast(RenderLevelLastEvent event) {
        Map<ScanResultProvider, List<ScanResult>> map = renderingResults;
        synchronized (map) {
            if (renderingResults.isEmpty()) {
                return;
            }
            viewModelStack = new PoseStack();
            viewModelStack.m_85850_().m_85861_().m_162210_(event.getPoseStack().m_85850_().m_85861_());
            projectionMatrix = event.getProjectionMatrix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Map<ScanResultProvider, List<ScanResult>> map = renderingResults;
        synchronized (map) {
            if (renderingResults.isEmpty()) {
                return;
            }
            RenderSystem.m_157183_();
            RenderSystem.m_157425_((Matrix4f)projectionMatrix);
            RenderSystem.m_157191_().m_85836_();
            RenderSystem.m_157191_().m_85850_().m_85861_().m_27624_();
            RenderSystem.m_157182_();
            ScanManager.render(event.getPartialTicks(), viewModelStack, RenderSystem.m_157192_());
            RenderSystem.m_157191_().m_85849_();
            RenderSystem.m_157182_();
            RenderSystem.m_157424_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void render(float partialTicks, PoseStack poseStack, Matrix4f projectionMatrix) {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 pos = camera.m_90583_();
        Frustum frustum = new Frustum(poseStack.m_85850_().m_85861_(), projectionMatrix);
        frustum.m_113002_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        RenderSystem.m_69465_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_85837_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
        MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        try {
            for (Map.Entry<ScanResultProvider, List<ScanResult>> entry : renderingResults.entrySet()) {
                for (ScanResult result : entry.getValue()) {
                    AABB bounds = result.getRenderBounds();
                    if (bounds != null && !frustum.m_113029_(bounds)) continue;
                    renderingList.add(result);
                }
                if (renderingList.isEmpty()) continue;
                entry.getKey().render((MultiBufferSource)renderTypeBuffer, poseStack, camera, partialTicks, renderingList);
                renderingList.clear();
            }
        }
        finally {
            renderingList.clear();
        }
        renderTypeBuffer.m_109911_();
        poseStack.m_85849_();
        RenderSystem.m_69482_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clear() {
        pendingResults.clear();
        Map<ScanResultProvider, List<ScanResult>> map = renderingResults;
        synchronized (map) {
            renderingResults.forEach((provider, results) -> {
                provider.reset();
                results.forEach(ScanResult::close);
            });
            renderingResults.clear();
        }
        lastScanCenter = null;
        currentStart = -1L;
    }
}

