/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.override;

import java.util.Arrays;
import net.optifine.BlockPosM;
import net.optifine.render.RenderEnv;
import net.optifine.util.ArrayCache;

public class ChunkCacheOF
implements bzg {
    private final esc chunkCache;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int sizeXZ;
    private int[] combinedLights;
    private coc[] blockStates;
    private caz[] biomes;
    private final int arraySize;
    private RenderEnv renderEnv;
    private static final ArrayCache cacheCombinedLights = new ArrayCache(Integer.TYPE, 16);
    private static final ArrayCache cacheBlockStates = new ArrayCache(coc.class, 16);
    private static final ArrayCache cacheBiomes = new ArrayCache(caz.class, 16);

    public ChunkCacheOF(esc chunkCache, gh posFromIn, gh posToIn, int subIn) {
        this.chunkCache = chunkCache;
        int minChunkX = posFromIn.u() - subIn >> 4;
        int minChunkY = posFromIn.v() - subIn >> 4;
        int minChunkZ = posFromIn.w() - subIn >> 4;
        int maxChunkX = posToIn.u() + subIn >> 4;
        int maxChunkY = posToIn.v() + subIn >> 4;
        int maxChunkZ = posToIn.w() + subIn >> 4;
        this.sizeX = maxChunkX - minChunkX + 1 << 4;
        this.sizeY = maxChunkY - minChunkY + 1 << 4;
        this.sizeZ = maxChunkZ - minChunkZ + 1 << 4;
        this.sizeXZ = this.sizeX * this.sizeZ;
        this.arraySize = this.sizeX * this.sizeY * this.sizeZ;
        this.posX = minChunkX << 4;
        this.posY = minChunkY << 4;
        this.posZ = minChunkZ << 4;
    }

    public int getPositionIndex(gh pos) {
        int dx = pos.u() - this.posX;
        if (dx < 0 || dx >= this.sizeX) {
            return -1;
        }
        int dy = pos.v() - this.posY;
        if (dy < 0 || dy >= this.sizeY) {
            return -1;
        }
        int dz = pos.w() - this.posZ;
        if (dz < 0 || dz >= this.sizeZ) {
            return -1;
        }
        return dy * this.sizeXZ + dz * this.sizeX + dx;
    }

    public int a(cam type, gh pos) {
        return this.chunkCache.a(type, pos);
    }

    public coc a_(gh pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.blockStates == null) {
            return this.chunkCache.a_(pos);
        }
        coc iblockstate = this.blockStates[index];
        if (iblockstate == null) {
            this.blockStates[index] = iblockstate = this.chunkCache.a_(pos);
        }
        return iblockstate;
    }

    public void renderStart() {
        if (this.combinedLights == null) {
            this.combinedLights = (int[])cacheCombinedLights.allocate(this.arraySize);
        }
        if (this.blockStates == null) {
            this.blockStates = (coc[])cacheBlockStates.allocate(this.arraySize);
        }
        if (this.biomes == null) {
            this.biomes = (caz[])cacheBiomes.allocate(this.arraySize);
        }
        Arrays.fill(this.combinedLights, -1);
        Arrays.fill(this.blockStates, null);
        Arrays.fill(this.biomes, null);
        this.loadBlockStates();
    }

    private void loadBlockStates() {
        if (this.sizeX != 48 || this.sizeY != 48 || this.sizeZ != 48) {
            return;
        }
        cqi chunk = this.chunkCache.getChunk(1, 1);
        BlockPosM pos = new BlockPosM();
        for (int y = 16; y < 32; ++y) {
            int dy = y * this.sizeXZ;
            for (int z = 16; z < 32; ++z) {
                int dz = z * this.sizeX;
                for (int x = 16; x < 32; ++x) {
                    coc bs;
                    pos.setXyz(this.posX + x, this.posY + y, this.posZ + z);
                    int index = dy + dz + x;
                    this.blockStates[index] = bs = chunk.a_((gh)pos);
                }
            }
        }
    }

    public void renderFinish() {
        cacheCombinedLights.free((Object)this.combinedLights);
        this.combinedLights = null;
        cacheBlockStates.free((Object)this.blockStates);
        this.blockStates = null;
        cacheBiomes.free((Object)this.biomes);
        this.biomes = null;
    }

    public int[] getCombinedLights() {
        return this.combinedLights;
    }

    public caz getBiome(gh pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.biomes == null) {
            return this.chunkCache.getBiome(pos);
        }
        caz biome = this.biomes[index];
        if (biome == null) {
            this.biomes[index] = biome = this.chunkCache.getBiome(pos);
        }
        return biome;
    }

    public clz c_(gh pos) {
        return this.chunkCache.c_(pos);
    }

    public boolean f(gh pos) {
        return this.chunkCache.f(pos);
    }

    public dhv b_(gh pos) {
        return this.a_(pos).n();
    }

    public int a(gh blockPosIn, bzo colorResolverIn) {
        return this.chunkCache.a(blockPosIn, colorResolverIn);
    }

    public dhm l_() {
        return this.chunkCache.l_();
    }

    public RenderEnv getRenderEnv() {
        return this.renderEnv;
    }

    public void setRenderEnv(RenderEnv renderEnv) {
        this.renderEnv = renderEnv;
    }

    public float a(gm directionIn, boolean shadeIn) {
        return this.chunkCache.a(directionIn, shadeIn);
    }

    public int v_() {
        return this.chunkCache.v_();
    }

    public int u_() {
        return this.chunkCache.u_();
    }
}

