/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class OpenBookCommand {
    private static final SuggestionProvider<CommandSourceStack> BOOK_ID_SUGGESTER = (ctx, builder) -> {
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, Book> e : BookRegistry.INSTANCE.books.entrySet()) {
            if (e.getValue().isExtension) continue;
            ids.add(e.getKey());
        }
        return SharedSuggestionProvider.m_82926_(ids, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> disp) {
        disp.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"open-patchouli-book").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"book", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(BOOK_ID_SUGGESTER).executes(ctx -> OpenBookCommand.doIt(EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"book"), null, 0))).then(Commands.m_82129_((String)"entry", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> OpenBookCommand.doIt(EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"book"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"entry"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))))));
    }

    private static int doIt(Collection<ServerPlayer> players, ResourceLocation book, @Nullable ResourceLocation entry, int page) {
        for (ServerPlayer player : players) {
            if (entry != null) {
                PatchouliAPI.get().openBookEntry(player, book, entry, page);
                continue;
            }
            PatchouliAPI.get().openBookGUI(player, book);
        }
        return players.size();
    }
}

