/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookResize;
import vazkii.patchouli.common.book.Book;

public class GuiBookWriter
extends GuiBook {
    BookTextRenderer text;
    BookTextRenderer editableText;
    EditBox textfield;
    private static String savedText = "";
    private static boolean drawHeader;

    public GuiBookWriter(Book book) {
        super(book, TextComponent.f_131282_);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.text = new BookTextRenderer(this, (Component)new TranslatableComponent("patchouli.gui.lexicon.editor.info"), 15, 38);
        this.textfield = new EditBox(this.f_96547_, 10, 140, 116, 20, TextComponent.f_131282_);
        this.textfield.m_94199_(Integer.MAX_VALUE);
        this.textfield.m_94144_(savedText);
        this.m_142416_(new GuiButtonBookResize(this, this.bookLeft + 115, this.bookTop + 156 - 36, false, this::handleButtonResize));
        this.refreshText();
    }

    @Override
    void drawForegroundElements(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        super.drawForegroundElements(ms, mouseX, mouseY, partialTicks);
        this.drawCenteredStringNoShadow(ms, I18n.m_118938_((String)"patchouli.gui.lexicon.editor", (Object[])new Object[0]), 73, 18, this.book.headerColor);
        GuiBookWriter.drawSeparator(ms, this.book, 15, 30);
        if (drawHeader) {
            this.drawCenteredStringNoShadow(ms, I18n.m_118938_((String)"patchouli.gui.lexicon.editor.mock_header", (Object[])new Object[0]), 199, 18, this.book.headerColor);
            GuiBookWriter.drawSeparator(ms, this.book, 141, 30);
        }
        this.textfield.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.text.render(ms, mouseX, mouseY);
        this.editableText.render(ms, mouseX, mouseY);
    }

    @Override
    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        return this.textfield.m_6375_(this.getRelativeX(mouseX), this.getRelativeY(mouseY), mouseButton) || this.text.click(mouseX, mouseY, mouseButton) || this.editableText.click(mouseX, mouseY, mouseButton) || super.mouseClickedScaled(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (this.textfield.m_7933_(key, scanCode, modifiers)) {
            this.refreshText();
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public boolean m_5534_(char c, int i) {
        if (this.textfield.m_5534_(c, i)) {
            this.refreshText();
            return true;
        }
        return super.m_5534_(c, i);
    }

    public void handleButtonResize(Button button) {
        drawHeader = !drawHeader;
        this.refreshText();
    }

    public void refreshText() {
        int yPos = 18 + (drawHeader ? 22 : -4);
        savedText = this.textfield.m_94155_();
        try {
            this.editableText = new BookTextRenderer(this, (Component)new TextComponent(savedText), 141, yPos);
        }
        catch (Throwable e) {
            this.editableText = new BookTextRenderer(this, (Component)new TextComponent("[ERROR]"), 141, yPos);
            PatchouliAPI.LOGGER.catching(e);
        }
    }
}

