/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.render.Styles;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SecurityCardItem
extends Item {
    private static final String NBT_OWNER = "Owner";
    private static final String NBT_OWNER_NAME = "OwnerName";
    private static final String NBT_PERMISSION = "Permission_%d";

    public SecurityCardItem() {
        super(new Item.Properties().m_41491_(RS.CREATIVE_MODE_TAB).m_41487_(1));
    }

    @Nullable
    public static UUID getOwner(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_OWNER)) {
            return UUID.fromString(stack.m_41783_().m_128461_(NBT_OWNER));
        }
        return null;
    }

    public static boolean hasPermission(ItemStack stack, Permission permission) {
        String id = String.format(NBT_PERMISSION, permission.getId());
        if (stack.m_41782_() && stack.m_41783_().m_128441_(id)) {
            return stack.m_41783_().m_128471_(id);
        }
        return false;
    }

    public static void setPermission(ItemStack stack, Permission permission, boolean state) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128379_(String.format(NBT_PERMISSION, permission.getId()), state);
    }

    public static boolean isValid(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_OWNER);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            stack.m_41751_(new CompoundTag());
            stack.m_41783_().m_128359_(NBT_OWNER, player.m_36316_().getId().toString());
            stack.m_41783_().m_128359_(NBT_OWNER_NAME, player.m_36316_().getName());
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_OWNER_NAME)) {
            tooltip.add((Component)new TranslatableComponent("item.refinedstorage.security_card.owner", new Object[]{stack.m_41783_().m_128461_(NBT_OWNER_NAME)}).m_6270_(Styles.GRAY));
        }
        for (Permission permission : Permission.values()) {
            if (!SecurityCardItem.hasPermission(stack, permission)) continue;
            tooltip.add((Component)new TextComponent("- ").m_7220_((Component)new TranslatableComponent("gui.refinedstorage.security_manager.permission." + permission.getId())).m_6270_(Styles.GRAY));
        }
    }
}

