/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import li.cil.sedna.fs.DirectoryEntry;
import li.cil.sedna.fs.FileHandle;
import li.cil.sedna.fs.FileSystem;
import li.cil.sedna.fs.FileSystemStats;
import li.cil.sedna.fs.Path;

public final class LayeredFileSystem
implements FileSystem {
    private final ArrayList<FileSystem> fileSystems = new ArrayList();

    public void addLayer(FileSystem fileSystem) {
        this.fileSystems.add(0, fileSystem);
    }

    public void clear() {
        this.fileSystems.clear();
    }

    public FileSystemStats statfs() throws IOException {
        FileSystemStats result = new FileSystemStats();
        for (FileSystem fileSystem : this.fileSystems) {
            FileSystemStats stats = fileSystem.statfs();
            result.blockCount += stats.blockCount;
            result.freeBlockCount += stats.freeBlockCount;
            result.availableBlockCount += stats.availableBlockCount;
            result.fileCount += stats.fileCount;
            result.freeFileCount += stats.freeFileCount;
        }
        return result;
    }

    public long getUniqueId(Path path) throws IOException {
        for (FileSystem fileSystem : this.fileSystems) {
            if (!fileSystem.exists(path)) continue;
            return fileSystem.getUniqueId(path);
        }
        throw new FileNotFoundException();
    }

    public boolean exists(Path path) {
        for (FileSystem fileSystem : this.fileSystems) {
            if (!fileSystem.exists(path)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirectory(Path path) {
        for (FileSystem fileSystem : this.fileSystems) {
            if (!fileSystem.exists(path)) continue;
            return fileSystem.isDirectory(path);
        }
        return false;
    }

    public boolean isWritable(Path path) {
        return false;
    }

    public boolean isReadable(Path path) {
        for (FileSystem fileSystem : this.fileSystems) {
            if (!fileSystem.exists(path)) continue;
            return fileSystem.isReadable(path);
        }
        return false;
    }

    public boolean isExecutable(Path path) {
        for (FileSystem fileSystem : this.fileSystems) {
            if (!fileSystem.exists(path)) continue;
            return fileSystem.isExecutable(path);
        }
        return false;
    }

    public BasicFileAttributes getAttributes(Path path) throws IOException {
        for (FileSystem fileSystem : this.fileSystems) {
            if (!fileSystem.exists(path)) continue;
            return fileSystem.getAttributes(path);
        }
        throw new FileNotFoundException();
    }

    public void mkdir(Path path) throws IOException {
        throw new IOException();
    }

    public FileHandle open(Path path, int flags) throws IOException {
        if ((flags & 2) != 0) {
            throw new IOException();
        }
        if (this.isDirectory(path)) {
            ArrayList<FileHandle> fileHandles = new ArrayList<FileHandle>();
            for (FileSystem fileSystem : this.fileSystems) {
                if (!fileSystem.isDirectory(path)) continue;
                fileHandles.add(fileSystem.open(path, flags));
            }
            return new LayeredDirectoryFileHandle(fileHandles);
        }
        for (FileSystem fileSystem : this.fileSystems) {
            if (!fileSystem.exists(path)) continue;
            return fileSystem.open(path, flags);
        }
        throw new FileNotFoundException();
    }

    public FileHandle create(Path path, int flags) throws IOException {
        throw new IOException();
    }

    public void unlink(Path path) throws IOException {
        throw new IOException();
    }

    public void rename(Path oldPath, Path newPath) throws IOException {
        throw new IOException();
    }

    private static final class LayeredDirectoryFileHandle
    implements FileHandle {
        private final ArrayList<DirectoryEntry> entries = new ArrayList();

        public LayeredDirectoryFileHandle(ArrayList<FileHandle> fileHandles) {
            for (FileHandle fileHandle : fileHandles) {
                try {
                    List layer = fileHandle.readdir();
                    for (DirectoryEntry entry : layer) {
                        if (!this.entries.stream().noneMatch(e -> Objects.equals(e.name, entry.name))) continue;
                        this.entries.add(entry);
                    }
                }
                catch (IOException iOException) {
                }
            }
        }

        public int read(long offset, ByteBuffer buffer) throws IOException {
            throw new IOException();
        }

        public int write(long offset, ByteBuffer buffer) throws IOException {
            throw new IOException();
        }

        public List<DirectoryEntry> readdir() {
            return this.entries;
        }

        public void close() {
        }
    }
}

