/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import li.cil.oc2.api.bus.DeviceBusElement;
import li.cil.oc2.api.bus.device.DeviceType;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.api.bus.device.vm.VMDevice;
import li.cil.oc2.common.bus.AbstractDeviceBusElement;
import li.cil.oc2.common.container.DeviceItemStackHandler;
import li.cil.oc2.common.container.TypedDeviceItemStackHandler;
import li.cil.oc2.common.util.RegistryUtils;
import li.cil.oc2.common.vm.VMItemStackHandlers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public abstract class AbstractVMItemStackHandlers
implements VMItemStackHandlers {
    private static final long ITEM_DEVICE_BASE_ADDRESS = 0x20000000L;
    private static final int ITEM_DEVICE_STRIDE = 4096;
    private static final long OTHER_DEVICE_BASE_ADDRESS = 0x30000000L;
    public final AbstractDeviceBusElement busElement = new BusElement();
    private final LinkedHashMap<DeviceType, DeviceItemStackHandler> itemHandlers = new LinkedHashMap();
    public final IItemHandler combinedItemHandlers;

    public AbstractVMItemStackHandlers(GroupDefinition ... groups) {
        for (GroupDefinition group : groups) {
            this.itemHandlers.put(group.deviceType, new ItemHandler(group.count, this::getDeviceQuery, group.deviceType));
        }
        this.combinedItemHandlers = new CombinedInvWrapper(this.itemHandlers.values().toArray(new IItemHandlerModifiable[0]));
    }

    @Override
    public Optional<IItemHandler> getItemHandler(DeviceType deviceType) {
        return Optional.ofNullable((IItemHandler)this.itemHandlers.get(deviceType));
    }

    @Override
    public boolean isEmpty() {
        for (int slot = 0; slot < this.combinedItemHandlers.getSlots(); ++slot) {
            if (this.combinedItemHandlers.getStackInSlot(slot).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public OptionalLong getDeviceAddressBase(VMDevice wrapper) {
        long address = 0x20000000L;
        for (Map.Entry<DeviceType, DeviceItemStackHandler> entry : this.itemHandlers.entrySet()) {
            DeviceType deviceType = entry.getKey();
            DeviceItemStackHandler handler = entry.getValue();
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getBusElement().groupContains(i, wrapper)) {
                    if (deviceType == DeviceTypes.MEMORY) {
                        return OptionalLong.empty();
                    }
                    return OptionalLong.of(address);
                }
                address += 4096L;
            }
        }
        return OptionalLong.of(0x30000000L);
    }

    @Override
    public void exportDeviceDataToItemStacks() {
        for (DeviceItemStackHandler handler : this.itemHandlers.values()) {
            handler.exportDeviceDataToItemStacks();
        }
    }

    public void saveItems(CompoundTag tag) {
        this.itemHandlers.forEach((deviceType, handler) -> {
            if (!handler.isEmpty()) {
                tag.m_128365_(RegistryUtils.key(deviceType), (Tag)handler.saveItems());
            }
        });
    }

    public CompoundTag saveItems() {
        CompoundTag tag = new CompoundTag();
        this.saveItems(tag);
        return tag;
    }

    public void loadItems(CompoundTag tag) {
        this.itemHandlers.forEach((deviceType, handler) -> handler.loadItems(tag.m_128469_(RegistryUtils.key(deviceType))));
    }

    public void saveDevices(CompoundTag tag) {
        this.itemHandlers.forEach((deviceType, handler) -> tag.m_128365_(RegistryUtils.key(deviceType), (Tag)handler.saveDevices()));
    }

    public CompoundTag saveDevices() {
        CompoundTag tag = new CompoundTag();
        this.saveDevices(tag);
        return tag;
    }

    public void loadDevices(CompoundTag tag) {
        this.itemHandlers.forEach((deviceType, handler) -> handler.loadDevices(tag.m_128469_(RegistryUtils.key(deviceType))));
    }

    protected abstract ItemDeviceQuery getDeviceQuery(ItemStack var1);

    protected void onContentsChanged(DeviceItemStackHandler itemHandler, int slot) {
    }

    private final class BusElement
    extends AbstractDeviceBusElement {
        private BusElement() {
        }

        @Override
        public Optional<Collection<LazyOptional<DeviceBusElement>>> getNeighbors() {
            return Optional.of((Collection)AbstractVMItemStackHandlers.this.itemHandlers.values().stream().map(h -> LazyOptional.of(() -> h.getBusElement())).collect(Collectors.toList()));
        }
    }

    public record GroupDefinition(DeviceType deviceType, int count) {
    }

    private final class ItemHandler
    extends TypedDeviceItemStackHandler {
        public ItemHandler(int size, Function<ItemStack, ItemDeviceQuery> queryFactory, DeviceType deviceType) {
            super(size, queryFactory, deviceType);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            AbstractVMItemStackHandlers.this.onContentsChanged(this, slot);
        }
    }
}

