/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ServerScheduler {
    private static final TickScheduler globalTickScheduler = new TickScheduler();
    private static final WeakHashMap<LevelAccessor, TickScheduler> levelTickSchedulers = new WeakHashMap();
    private static final WeakHashMap<LevelAccessor, SimpleScheduler> levelUnloadSchedulers = new WeakHashMap();
    private static final WeakHashMap<LevelAccessor, HashMap<ChunkPos, SimpleScheduler>> chunkLoadSchedulers = new WeakHashMap();
    private static final WeakHashMap<LevelAccessor, HashMap<ChunkPos, SimpleScheduler>> chunkUnloadSchedulers = new WeakHashMap();

    public static void initialize() {
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
    }

    public static void schedule(Runnable runnable) {
        ServerScheduler.schedule(runnable, 0);
    }

    public static void schedule(Runnable runnable, int afterTicks) {
        globalTickScheduler.schedule(runnable, afterTicks);
    }

    public static void schedule(LevelAccessor level, Runnable runnable) {
        ServerScheduler.schedule(level, runnable, 0);
    }

    public static void schedule(LevelAccessor level, Runnable runnable, int afterTicks) {
        TickScheduler scheduler = levelTickSchedulers.computeIfAbsent(level, w -> new TickScheduler());
        scheduler.schedule(runnable, afterTicks);
    }

    public static void scheduleOnUnload(LevelAccessor level, Runnable listener) {
        levelUnloadSchedulers.computeIfAbsent(level, unused -> new SimpleScheduler()).add(listener);
    }

    public static void cancelOnUnload(@Nullable LevelAccessor level, Runnable listener) {
        if (level == null) {
            return;
        }
        SimpleScheduler scheduler = levelUnloadSchedulers.get(level);
        if (scheduler != null) {
            scheduler.remove(listener);
        }
    }

    public static void scheduleOnLoad(LevelAccessor level, ChunkPos chunkPos, Runnable listener) {
        chunkLoadSchedulers.computeIfAbsent(level, unused -> new HashMap()).computeIfAbsent(chunkPos, unused -> new SimpleScheduler()).add(listener);
    }

    public static void cancelOnLoad(@Nullable LevelAccessor level, ChunkPos chunkPos, Runnable listener) {
        if (level == null) {
            return;
        }
        HashMap<ChunkPos, SimpleScheduler> chunkMap = chunkLoadSchedulers.get(level);
        if (chunkMap == null) {
            return;
        }
        SimpleScheduler scheduler = chunkMap.get(chunkPos);
        if (scheduler != null) {
            scheduler.remove(listener);
        }
    }

    public static void scheduleOnUnload(LevelAccessor level, ChunkPos chunkPos, Runnable listener) {
        chunkUnloadSchedulers.computeIfAbsent(level, unused -> new HashMap()).computeIfAbsent(chunkPos, unused -> new SimpleScheduler()).add(listener);
    }

    public static void cancelOnUnload(@Nullable LevelAccessor level, ChunkPos chunkPos, Runnable listener) {
        if (level == null) {
            return;
        }
        HashMap<ChunkPos, SimpleScheduler> chunkMap = chunkUnloadSchedulers.get(level);
        if (chunkMap == null) {
            return;
        }
        SimpleScheduler scheduler = chunkMap.get(chunkPos);
        if (scheduler != null) {
            scheduler.remove(listener);
        }
    }

    private static final class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void handleServerStoppedEvent(ServerStoppedEvent event) {
            globalTickScheduler.clear();
            levelTickSchedulers.clear();
            levelUnloadSchedulers.clear();
            chunkLoadSchedulers.clear();
            chunkUnloadSchedulers.clear();
        }

        @SubscribeEvent
        public static void handleLevelUnload(WorldEvent.Unload event) {
            LevelAccessor level = event.getWorld();
            levelTickSchedulers.remove(level);
            chunkLoadSchedulers.remove(level);
            chunkUnloadSchedulers.remove(level);
            SimpleScheduler scheduler = levelUnloadSchedulers.remove(level);
            if (scheduler != null) {
                scheduler.run();
            }
        }

        @SubscribeEvent
        public static void handleChunkLoad(ChunkEvent.Load event) {
            HashMap<ChunkPos, SimpleScheduler> chunkMap = chunkLoadSchedulers.get(event.getWorld());
            if (chunkMap == null) {
                return;
            }
            SimpleScheduler scheduler = chunkMap.get(event.getChunk().m_7697_());
            if (scheduler != null) {
                scheduler.run();
            }
        }

        @SubscribeEvent
        public static void handleChunkUnload(ChunkEvent.Unload event) {
            HashMap<ChunkPos, SimpleScheduler> chunkMap = chunkUnloadSchedulers.get(event.getWorld());
            if (chunkMap == null) {
                return;
            }
            SimpleScheduler scheduler = chunkMap.get(event.getChunk().m_7697_());
            if (scheduler != null) {
                scheduler.run();
            }
        }

        @SubscribeEvent
        public static void handleServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                globalTickScheduler.tick();
                for (TickScheduler scheduler : levelTickSchedulers.values()) {
                    scheduler.tick();
                }
            }
        }

        @SubscribeEvent
        public static void handleLevelTick(TickEvent.WorldTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            globalTickScheduler.processQueue();
            TickScheduler scheduler = levelTickSchedulers.get(event.world);
            if (scheduler != null) {
                scheduler.processQueue();
            }
        }
    }

    private static final class TickScheduler {
        private final PriorityQueue<ScheduledRunnable> queue = new PriorityQueue();
        private int currentTick;

        private TickScheduler() {
        }

        public void schedule(Runnable runnable, int afterTicks) {
            this.queue.add(new ScheduledRunnable(this.currentTick + afterTicks, runnable));
        }

        public void processQueue() {
            while (!this.queue.isEmpty() && this.queue.peek().tick <= this.currentTick) {
                this.queue.poll().runnable.run();
            }
        }

        public void tick() {
            ++this.currentTick;
        }

        public void clear() {
            this.currentTick = 0;
            this.queue.clear();
        }
    }

    private static final class SimpleScheduler {
        private final Set<Runnable> listeners = Collections.newSetFromMap(new WeakHashMap());

        private SimpleScheduler() {
        }

        public void add(Runnable listener) {
            this.listeners.add(listener);
        }

        public void remove(Runnable listener) {
            this.listeners.remove(listener);
        }

        public void run() {
            for (Runnable runnable : this.listeners) {
                runnable.run();
            }
            this.listeners.clear();
        }
    }

    private record ScheduledRunnable(int tick, Runnable runnable) implements Comparable<ScheduledRunnable>
    {
        @Override
        public int compareTo(ScheduledRunnable o) {
            return Integer.compare(this.tick, o.tick);
        }
    }
}

