/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class RegistryUtils {
    private static final List<DeferredRegister<?>> ENTRIES = new ArrayList();
    private static Phase phase = Phase.PRE_INIT;

    public static <T extends IForgeRegistryEntry<T>> DeferredRegister<T> create(Class<T> type) {
        if (phase != Phase.INIT) {
            throw new IllegalStateException();
        }
        DeferredRegister entry = DeferredRegister.create(type, (String)"oc2");
        ENTRIES.add(entry);
        return entry;
    }

    public static <T extends IForgeRegistryEntry<T>> DeferredRegister<T> create(IForgeRegistry<T> registry) {
        if (phase != Phase.INIT) {
            throw new IllegalStateException();
        }
        DeferredRegister entry = DeferredRegister.create(registry, (String)"oc2");
        ENTRIES.add(entry);
        return entry;
    }

    public static void begin() {
        if (phase != Phase.PRE_INIT) {
            throw new IllegalStateException();
        }
        phase = Phase.INIT;
    }

    public static void finish() {
        if (phase != Phase.INIT) {
            throw new IllegalStateException();
        }
        phase = Phase.POST_INIT;
        for (DeferredRegister<?> register : ENTRIES) {
            register.register(FMLJavaModLoadingContext.get().getModEventBus());
        }
        ENTRIES.clear();
    }

    public static <T> String key(IForgeRegistryEntry<T> registryEntry) {
        return Objects.requireNonNull(registryEntry.getRegistryName()).toString();
    }

    public static <T> Optional<String> optionalKey(@Nullable IForgeRegistryEntry<T> registryEntry) {
        if (registryEntry == null) {
            return Optional.empty();
        }
        ResourceLocation providerName = registryEntry.getRegistryName();
        if (providerName == null) {
            return Optional.empty();
        }
        return Optional.of(providerName.toString());
    }

    private RegistryUtils() {
    }

    private static enum Phase {
        PRE_INIT,
        INIT,
        POST_INIT;

    }
}

