/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.util.Optional;
import java.util.function.Supplier;
import li.cil.oc2.api.bus.device.provider.BlockDeviceQuery;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.common.util.Location;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class LocationSupplierUtils {
    public static Supplier<Optional<Location>> of(BlockEntity blockEntity) {
        return () -> Location.of(blockEntity);
    }

    public static Supplier<Optional<Location>> of(Entity entity) {
        return () -> Location.of(entity);
    }

    public static Supplier<Optional<Location>> of(BlockDeviceQuery query) {
        Optional<Location> location = Optional.of(new Location((LevelAccessor)query.getLevel(), query.getQueryPosition()));
        return () -> location;
    }

    public static Supplier<Optional<Location>> of(ItemDeviceQuery query) {
        Optional<BlockEntity> blockEntity = query.getContainerBlockEntity();
        if (blockEntity.isPresent()) {
            return () -> Location.of((BlockEntity)blockEntity.get());
        }
        Optional<Entity> entity = query.getContainerEntity();
        if (entity.isPresent()) {
            return () -> Location.of((Entity)entity.get());
        }
        return Optional::empty;
    }
}

