/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class LevelUtils {
    @Nullable
    public static BlockEntity getBlockEntityIfChunkExists(LevelAccessor level, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
            return null;
        }
        return level.m_7702_(pos);
    }

    @Nullable
    public static String getBlockName(LevelAccessor level, BlockPos pos) {
        ResourceLocation registryName;
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
            return null;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null && (registryName = blockEntity.m_58903_().getRegistryName()) != null) {
            return registryName.toString();
        }
        Block block = level.m_8055_(pos).m_60734_();
        ResourceLocation registryName2 = block.getRegistryName();
        if (registryName2 != null) {
            return registryName2.toString();
        }
        if (blockEntity != null) {
            return blockEntity.getClass().getSimpleName();
        }
        return block.getClass().getSimpleName();
    }

    public static void playSound(LevelAccessor level, BlockPos pos, SoundType soundType, Function<SoundType, SoundEvent> soundEvent) {
        LevelUtils.playSound(level, pos, soundType, soundEvent.apply(soundType));
    }

    public static void playSound(LevelAccessor level, BlockPos pos, SoundType soundType, SoundEvent soundEvent) {
        LevelUtils.playSound(level, pos, soundEvent, SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
    }

    public static void playSound(LevelAccessor level, BlockPos pos, SoundEvent soundEvent, SoundSource soundCategory, float volume, float pitch) {
        level.m_5594_(null, pos, soundEvent, soundCategory, volume, pitch);
    }
}

