/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.item.crafting;

import com.google.gson.JsonObject;
import li.cil.oc2.common.integration.Wrenches;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public final class WrenchRecipe
extends ShapelessRecipe {
    public WrenchRecipe(ShapelessRecipe recipe) {
        super(recipe.m_6423_(), recipe.m_6076_(), recipe.m_8043_(), recipe.m_7527_());
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inventory) {
        NonNullList result = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
            ItemStack stack = inventory.m_8020_(slot);
            if (stack.hasContainerItem()) {
                result.set(slot, (Object)stack.getContainerItem());
                continue;
            }
            if (!Wrenches.isWrench(stack)) continue;
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            result.set(slot, (Object)copy);
        }
        return result;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<WrenchRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public WrenchRecipe fromJson(ResourceLocation location, JsonObject json) {
            return new WrenchRecipe((ShapelessRecipe)f_44077_.m_6729_(location, json));
        }

        @Nullable
        public WrenchRecipe fromNetwork(ResourceLocation location, FriendlyByteBuf buffer) {
            ShapelessRecipe recipe = (ShapelessRecipe)f_44077_.m_8005_(location, buffer);
            if (recipe == null) {
                return null;
            }
            return new WrenchRecipe(recipe);
        }

        public void toNetwork(FriendlyByteBuf buffer, WrenchRecipe recipe) {
            f_44077_.m_6178_(buffer, (Recipe)recipe);
        }
    }
}

