/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.item;

import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.data.Firmware;
import li.cil.oc2.common.bus.device.data.Firmwares;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.item.ModItem;
import li.cil.oc2.common.util.ItemStackUtils;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class FlashMemoryWithExternalDataItem
extends ModItem {
    public static final String FIRMWARE_TAG_NAME = "firmware";
    private final ResourceLocation defaultData;
    @Nullable
    private String descriptionId;

    public FlashMemoryWithExternalDataItem(ResourceLocation defaultData) {
        super(FlashMemoryWithExternalDataItem.createProperties().m_41487_(1));
        this.defaultData = defaultData;
    }

    @Nullable
    public Firmware getFirmware(ItemStack stack) {
        if (stack.m_41619_() || stack.m_41720_() != this) {
            return null;
        }
        String registryName = ItemStackUtils.getModDataTag(stack).m_128461_(FIRMWARE_TAG_NAME);
        ResourceLocation location = this.defaultData;
        if (!StringUtil.m_14408_((String)registryName)) {
            try {
                location = new ResourceLocation(registryName);
            }
            catch (ResourceLocationException resourceLocationException) {
                // empty catch block
            }
        }
        return (Firmware)Firmwares.REGISTRY.get().getValue(location);
    }

    public ItemStack withFirmware(ItemStack stack, Firmware firmware) {
        if (stack.m_41619_() || stack.m_41720_() != this) {
            return stack;
        }
        ResourceLocation key = Firmwares.REGISTRY.get().getKey((IForgeRegistryEntry)firmware);
        if (key == null) {
            return stack;
        }
        ItemStackUtils.getOrCreateModDataTag(stack).m_128359_(FIRMWARE_TAG_NAME, key.toString());
        return stack;
    }

    public ItemStack withFirmware(Firmware firmware) {
        return this.withFirmware(new ItemStack((ItemLike)this), firmware);
    }

    public Component m_7626_(ItemStack stack) {
        Firmware firmware = this.getFirmware(stack);
        if (firmware != null) {
            return new TextComponent("").m_7220_(super.m_7626_(stack)).m_130946_(" (").m_7220_(firmware.getDisplayName()).m_130946_(")");
        }
        return super.m_7626_(stack);
    }

    protected String m_41467_() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"item", (ResourceLocation)Items.FLASH_MEMORY.getId());
        }
        return this.descriptionId;
    }
}

