/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.item;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.block.BusCableBlock;
import li.cil.oc2.common.item.ModBlockItem;
import li.cil.oc2.common.util.LevelUtils;
import li.cil.oc2.common.util.TooltipUtils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class BusCableItem
extends ModBlockItem {
    public BusCableItem(Block block) {
        super(block);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        TooltipUtils.addEnergyConsumption(Config.busCableEnergyPerTick, tooltip);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult result = BusCableItem.tryAddToBlock(context);
        return result.m_19077_() ? result : super.m_6225_(context);
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        InteractionResult result = BusCableItem.tryAddToBlock((UseOnContext)context);
        return result.m_19077_() ? result : super.m_40576_(context);
    }

    private static InteractionResult tryAddToBlock(UseOnContext context) {
        BlockState state;
        BlockPos pos;
        Level level = context.m_43725_();
        if (!BusCableBlock.addCable(level, pos = context.m_8083_(), state = level.m_8055_(pos))) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10591_.m_59469_(serverPlayer, pos, stack);
        }
        LevelUtils.playSound((LevelAccessor)level, pos, state.getSoundType((LevelReader)level, pos, (Entity)player), SoundType::m_56777_);
        if (player == null || !player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }
}

