/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.entity.robot;

import java.time.Duration;
import javax.annotation.Nullable;
import li.cil.oc2.common.entity.Robot;
import li.cil.oc2.common.entity.robot.AbstractRobotAction;
import li.cil.oc2.common.entity.robot.RobotActionResult;
import li.cil.oc2.common.entity.robot.RobotActions;
import li.cil.oc2.common.entity.robot.RotationDirection;
import li.cil.oc2.common.util.NBTUtils;
import li.cil.oc2.common.util.TickUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;

public final class RobotRotationAction
extends AbstractRobotAction {
    public static final float TARGET_EPSILON = 1.0E-4f;
    private static final float ROTATION_SPEED = 90.0f / (float)TickUtils.toTicks(Duration.ofSeconds(1L));
    private static final String DIRECTION_TAG_NAME = "direction";
    private static final String TARGET_TAG_NAME = "start";
    @Nullable
    private RotationDirection direction;
    @Nullable
    private Direction target;

    public RobotRotationAction(RotationDirection direction) {
        super(RobotActions.ROTATION);
        this.direction = direction.resolve();
    }

    RobotRotationAction(CompoundTag tag) {
        super(RobotActions.ROTATION, tag);
    }

    public static void rotateTowards(Robot robot, Direction targetRotation) {
        robot.m_146922_(Mth.m_14148_((float)robot.m_146908_(), (float)targetRotation.m_122435_(), (float)ROTATION_SPEED));
    }

    @Override
    public void initialize(Robot robot) {
        if (this.target == null) {
            this.target = robot.m_6350_();
            if (this.direction != null) {
                switch (this.direction) {
                    case LEFT: {
                        this.target = this.target.m_122428_();
                        break;
                    }
                    case RIGHT: {
                        this.target = this.target.m_122427_();
                    }
                }
            }
        }
        robot.m_20088_().m_135381_(Robot.TARGET_DIRECTION, (Object)this.target);
    }

    @Override
    public RobotActionResult perform(Robot robot) {
        if (this.target == null) {
            throw new IllegalStateException();
        }
        RobotRotationAction.rotateTowards(robot, this.target);
        if (Mth.m_14145_((float)robot.m_146908_(), (float)this.target.m_122435_()) < 1.0E-4f) {
            return RobotActionResult.SUCCESS;
        }
        return RobotActionResult.INCOMPLETE;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = super.serialize();
        NBTUtils.putEnum(tag, DIRECTION_TAG_NAME, this.direction);
        if (this.target != null) {
            NBTUtils.putEnum(tag, TARGET_TAG_NAME, this.target);
        }
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        this.direction = NBTUtils.getEnum(tag, DIRECTION_TAG_NAME, RotationDirection.class);
        if (this.direction == null) {
            this.direction = RotationDirection.LEFT;
        }
        this.direction = this.direction.resolve();
        if (tag.m_128425_(TARGET_TAG_NAME, 3)) {
            this.target = NBTUtils.getEnum(tag, TARGET_TAG_NAME, Direction.class);
        }
    }
}

