/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.entity.robot;

import java.util.ArrayList;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import li.cil.oc2.common.entity.Robot;
import li.cil.oc2.common.entity.robot.AbstractRobotAction;
import li.cil.oc2.common.entity.robot.AbstractRobotActionType;
import li.cil.oc2.common.entity.robot.RobotMovementActionType;
import li.cil.oc2.common.entity.robot.RobotRotationActionType;
import net.minecraft.nbt.CompoundTag;

public final class RobotActions {
    private static final String ACTION_TYPE_TAG_NAME = "action_type";
    private static final ArrayList<AbstractRobotActionType> ACTIONS = new ArrayList();
    public static final AbstractRobotActionType MOVEMENT = RobotActions.register(RobotMovementActionType::new);
    public static final AbstractRobotActionType ROTATION = RobotActions.register(RobotRotationActionType::new);

    public static void initializeData(Robot robot) {
        for (AbstractRobotActionType type : ACTIONS) {
            type.initializeData(robot);
        }
    }

    public static void performServer(Robot robot, AbstractRobotAction currentAction) {
        for (AbstractRobotActionType type : ACTIONS) {
            type.performServer(robot, currentAction);
        }
    }

    public static void performClient(Robot robot) {
        for (AbstractRobotActionType type : ACTIONS) {
            type.performClient(robot);
        }
    }

    public static CompoundTag serialize(AbstractRobotAction action) {
        CompoundTag actionTag = action.serialize();
        actionTag.m_128405_(ACTION_TYPE_TAG_NAME, action.getType().getId());
        return actionTag;
    }

    @Nullable
    public static AbstractRobotAction deserialize(CompoundTag tag) {
        int type = tag.m_128451_(ACTION_TYPE_TAG_NAME);
        if (type < 1 || type > ACTIONS.size()) {
            return null;
        }
        AbstractRobotActionType actionType = ACTIONS.get(type - 1);
        return actionType.deserialize(tag);
    }

    private static AbstractRobotActionType register(IntFunction<? extends AbstractRobotActionType> factory) {
        AbstractRobotActionType type = factory.apply(ACTIONS.size() + 1);
        ACTIONS.add(type);
        return type;
    }
}

