/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.container;

import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.common.blockentity.ComputerBlockEntity;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.container.AbstractComputerContainer;
import li.cil.oc2.common.container.Containers;
import li.cil.oc2.common.container.DeviceTypeSlotItemHandler;
import li.cil.oc2.common.container.IntPrecisionContainerData;
import li.cil.oc2.common.vm.VMItemStackHandlers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public final class ComputerInventoryContainer
extends AbstractComputerContainer {
    public static void createServer(final ComputerBlockEntity computer, final IEnergyStorage energy, final CommonDeviceBusController busController, ServerPlayer player) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent(computer.m_58900_().m_60734_().m_7705_());
            }

            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                return new ComputerInventoryContainer(id, computer, player, AbstractComputerContainer.createEnergyInfo(energy, busController));
            }
        }, (BlockPos)computer.m_58899_());
    }

    public static ComputerInventoryContainer createClient(int id, Inventory playerInventory, FriendlyByteBuf data) {
        BlockPos pos = data.m_130135_();
        BlockEntity blockEntity = playerInventory.f_35978_.f_19853_.m_7702_(pos);
        if (blockEntity instanceof ComputerBlockEntity) {
            ComputerBlockEntity computer = (ComputerBlockEntity)blockEntity;
            return new ComputerInventoryContainer(id, computer, playerInventory.f_35978_, ComputerInventoryContainer.createClientEnergyInfo());
        }
        throw new IllegalArgumentException();
    }

    private ComputerInventoryContainer(int id, ComputerBlockEntity computer, Player player, IntPrecisionContainerData energyInfo) {
        super((MenuType)Containers.COMPUTER.get(), id, player, computer, energyInfo);
        VMItemStackHandlers handlers = computer.getItemStackHandlers();
        handlers.getItemHandler(DeviceTypes.FLASH_MEMORY).ifPresent(itemHandler -> {
            if (itemHandler.getSlots() > 0) {
                this.m_38897_((Slot)new DeviceTypeSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.FLASH_MEMORY, 0, 64, 78));
            }
        });
        handlers.getItemHandler(DeviceTypes.MEMORY).ifPresent(itemHandler -> {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                this.m_38897_((Slot)new DeviceTypeSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.MEMORY, slot, 64 + slot * 18, 24));
            }
        });
        handlers.getItemHandler(DeviceTypes.HARD_DRIVE).ifPresent(itemHandler -> {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                this.m_38897_((Slot)new DeviceTypeSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.HARD_DRIVE, slot, 100 + slot % 2 * 18, 60 + slot / 2 * 18));
            }
        });
        handlers.getItemHandler(DeviceTypes.CARD).ifPresent(itemHandler -> {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                this.m_38897_((Slot)new DeviceTypeSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.CARD, slot, 38, 24 + slot * 18));
            }
        });
        this.createPlayerInventoryAndHotbarSlots(player.m_150109_(), 8, 115);
    }
}

