/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.provider.item;

import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.bus.device.item.HardDriveVMDevice;
import li.cil.oc2.common.bus.device.provider.util.AbstractItemDeviceProvider;
import li.cil.oc2.common.item.HardDriveItem;
import li.cil.oc2.common.util.LocationSupplierUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public final class HardDriveItemDeviceProvider
extends AbstractItemDeviceProvider {
    public HardDriveItemDeviceProvider() {
        super(HardDriveItem.class);
    }

    @Override
    public void unmount(@Nullable ItemDeviceQuery query, CompoundTag tag) {
        super.unmount(query, tag);
        HardDriveVMDevice.unmount(tag);
    }

    @Override
    protected Optional<ItemDevice> getItemDevice(ItemDeviceQuery query) {
        return Optional.of(new HardDriveVMDevice(query.getItemStack(), HardDriveItemDeviceProvider.getCapacity(query), false, LocationSupplierUtils.of(query)));
    }

    @Override
    protected int getItemDeviceEnergyConsumption(ItemDeviceQuery query) {
        return Math.max(1, (int)Math.round((double)HardDriveItemDeviceProvider.getCapacity(query) * Config.hardDriveEnergyPerMegabytePerTick / 1048576.0));
    }

    private static int getCapacity(ItemDeviceQuery query) {
        ItemStack stack = query.getItemStack();
        HardDriveItem item = (HardDriveItem)stack.m_41720_();
        return Mth.m_14045_((int)item.getCapacity(stack), (int)0, (int)Config.maxHardDriveSize);
    }
}

