/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.provider;

import java.util.function.Supplier;
import li.cil.oc2.api.bus.device.provider.BlockDeviceProvider;
import li.cil.oc2.api.bus.device.provider.ItemDeviceProvider;
import li.cil.oc2.common.bus.device.provider.block.BlockEntityCapabilityDeviceProvider;
import li.cil.oc2.common.bus.device.provider.block.BlockEntityDeviceProvider;
import li.cil.oc2.common.bus.device.provider.block.BlockStateDeviceProvider;
import li.cil.oc2.common.bus.device.provider.block.DiskDriveDeviceProvider;
import li.cil.oc2.common.bus.device.provider.block.EnergyStorageBlockDeviceProvider;
import li.cil.oc2.common.bus.device.provider.block.FluidHandlerBlockDeviceProvider;
import li.cil.oc2.common.bus.device.provider.block.ItemHandlerBlockDeviceProvider;
import li.cil.oc2.common.bus.device.provider.item.BlockOperationsModuleDeviceProvider;
import li.cil.oc2.common.bus.device.provider.item.FileImportExportCardItemDeviceProvider;
import li.cil.oc2.common.bus.device.provider.item.FlashMemoryItemDeviceProvider;
import li.cil.oc2.common.bus.device.provider.item.FlashMemoryWithExternalDataItemDeviceProvider;
import li.cil.oc2.common.bus.device.provider.item.HardDriveItemDeviceProvider;
import li.cil.oc2.common.bus.device.provider.item.HardDriveWithExternalDataItemDeviceProvider;
import li.cil.oc2.common.bus.device.provider.item.InventoryOperationsModuleDeviceProvider;
import li.cil.oc2.common.bus.device.provider.item.MemoryItemDeviceProvider;
import li.cil.oc2.common.bus.device.provider.item.NetworkInterfaceCardItemDeviceProvider;
import li.cil.oc2.common.bus.device.provider.item.NetworkTunnelCardItemDeviceProvider;
import li.cil.oc2.common.bus.device.provider.item.NetworkTunnelModuleItemDeviceProvider;
import li.cil.oc2.common.bus.device.provider.item.RedstoneInterfaceCardItemDeviceProvider;
import li.cil.oc2.common.bus.device.provider.item.SoundCardItemDeviceProvider;
import li.cil.oc2.common.util.RegistryUtils;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

public final class Providers {
    private static final DeferredRegister<BlockDeviceProvider> BLOCK_DEVICE_PROVIDERS = RegistryUtils.create(BlockDeviceProvider.class);
    private static final DeferredRegister<ItemDeviceProvider> ITEM_DEVICE_PROVIDERS = RegistryUtils.create(ItemDeviceProvider.class);
    public static final Supplier<IForgeRegistry<BlockDeviceProvider>> BLOCK_DEVICE_PROVIDER_REGISTRY = BLOCK_DEVICE_PROVIDERS.makeRegistry("block_device_providers", RegistryBuilder::new);
    public static final Supplier<IForgeRegistry<ItemDeviceProvider>> ITEM_DEVICE_PROVIDER_REGISTRY = ITEM_DEVICE_PROVIDERS.makeRegistry("item_device_providers", RegistryBuilder::new);

    public static void initialize() {
        BLOCK_DEVICE_PROVIDERS.register("block", BlockStateDeviceProvider::new);
        BLOCK_DEVICE_PROVIDERS.register("block_entity", BlockEntityDeviceProvider::new);
        BLOCK_DEVICE_PROVIDERS.register("block_entity/capability", BlockEntityCapabilityDeviceProvider::new);
        BLOCK_DEVICE_PROVIDERS.register("energy_storage", EnergyStorageBlockDeviceProvider::new);
        BLOCK_DEVICE_PROVIDERS.register("fluid_handler", FluidHandlerBlockDeviceProvider::new);
        BLOCK_DEVICE_PROVIDERS.register("item_handler", ItemHandlerBlockDeviceProvider::new);
        BLOCK_DEVICE_PROVIDERS.register("disk_drive", DiskDriveDeviceProvider::new);
        ITEM_DEVICE_PROVIDERS.register("memory", MemoryItemDeviceProvider::new);
        ITEM_DEVICE_PROVIDERS.register("hard_drive", HardDriveItemDeviceProvider::new);
        ITEM_DEVICE_PROVIDERS.register("hard_drive_custom", HardDriveWithExternalDataItemDeviceProvider::new);
        ITEM_DEVICE_PROVIDERS.register("flash_memory", FlashMemoryItemDeviceProvider::new);
        ITEM_DEVICE_PROVIDERS.register("flash_memory_custom", FlashMemoryWithExternalDataItemDeviceProvider::new);
        ITEM_DEVICE_PROVIDERS.register("redstone_interface_card", RedstoneInterfaceCardItemDeviceProvider::new);
        ITEM_DEVICE_PROVIDERS.register("network_interface_card", NetworkInterfaceCardItemDeviceProvider::new);
        ITEM_DEVICE_PROVIDERS.register("network_tunnel_card", NetworkTunnelCardItemDeviceProvider::new);
        ITEM_DEVICE_PROVIDERS.register("file_import_export_card", FileImportExportCardItemDeviceProvider::new);
        ITEM_DEVICE_PROVIDERS.register("sound_card", SoundCardItemDeviceProvider::new);
        ITEM_DEVICE_PROVIDERS.register("inventory_operations_module", InventoryOperationsModuleDeviceProvider::new);
        ITEM_DEVICE_PROVIDERS.register("block_operations_module", BlockOperationsModuleDeviceProvider::new);
        ITEM_DEVICE_PROVIDERS.register("network_tunnel_module", NetworkTunnelModuleItemDeviceProvider::new);
    }
}

