/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.item;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import li.cil.oc2.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2.api.bus.device.vm.context.VMContext;
import li.cil.oc2.api.capabilities.NetworkInterface;
import li.cil.oc2.common.bus.device.item.AbstractNetworkInterfaceItemDevice;
import li.cil.oc2.common.item.NetworkTunnelItem;
import li.cil.oc2.common.util.TickUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NetworkTunnelItemDevice
extends AbstractNetworkInterfaceItemDevice {
    public NetworkTunnelItemDevice(ItemStack identity) {
        super(identity);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return LazyOptional.empty();
    }

    @Override
    public VMDeviceLoadResult mount(VMContext context) {
        VMDeviceLoadResult result = super.mount(context);
        if (result.wasSuccessful()) {
            NetworkTunnelItem.getTunnelId((ItemStack)this.identity).ifPresent(id -> TunnelManager.registerEndpoint(id, this.getNetworkInterface()));
        }
        return result;
    }

    @Override
    public void unmount() {
        super.unmount();
        TunnelManager.unregisterEndpoint(this.getNetworkInterface());
    }

    @Mod.EventBusSubscriber
    private static final class TunnelManager {
        private static final int BYTES_PER_TICK = 32768 / TickUtils.toTicks(Duration.ofSeconds(1L));
        private static final int MIN_ETHERNET_FRAME_SIZE = 42;
        private static final BiMap<UUID, Set<NetworkInterface>> TUNNELS = HashBiMap.create();

        private TunnelManager() {
        }

        public static void registerEndpoint(UUID id, NetworkInterface networkInterface) {
            ((Set)TUNNELS.computeIfAbsent((Object)id, unused -> new HashSet())).add(networkInterface);
        }

        public static void unregisterEndpoint(NetworkInterface networkInterface) {
            for (Set tunnel : TUNNELS.values()) {
                tunnel.remove(networkInterface);
            }
        }

        @SubscribeEvent
        public static void handleServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                TunnelManager.pumpMessages();
            }
        }

        @SubscribeEvent
        public static void handleServerStopped(ServerStoppedEvent event) {
            TUNNELS.clear();
        }

        private static void pumpMessages() {
            Iterator iterator = TUNNELS.values().iterator();
            while (iterator.hasNext()) {
                Set tunnel = (Set)iterator.next();
                if (tunnel.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                TunnelManager.pumpMessages(tunnel);
            }
        }

        private static void pumpMessages(Collection<NetworkInterface> tunnel) {
            for (NetworkInterface source : tunnel) {
                byte[] frame;
                int byteBudget = BYTES_PER_TICK;
                while ((frame = source.readEthernetFrame()) != null && byteBudget > 0) {
                    byteBudget -= Math.max(frame.length, 42);
                    for (NetworkInterface destination : tunnel) {
                        if (destination == source) continue;
                        destination.writeEthernetFrame(source, frame, 1);
                    }
                }
            }
        }
    }
}

