/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import li.cil.ceres.api.Serialized;
import li.cil.oc2.api.bus.DeviceBusController;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.rpc.RPCDevice;
import li.cil.oc2.api.bus.device.rpc.RPCInvocation;
import li.cil.oc2.api.bus.device.rpc.RPCMethod;
import li.cil.oc2.api.bus.device.rpc.RPCMethodGroup;
import li.cil.oc2.api.bus.device.rpc.RPCParameter;
import li.cil.oc2.common.bus.device.rpc.RPCDeviceList;
import li.cil.oc2.common.bus.device.rpc.RPCMethodParameterTypeAdapters;
import li.cil.oc2.common.serialization.gson.EmptyRPCMethodGroupSerializer;
import li.cil.oc2.common.serialization.gson.MessageJsonDeserializer;
import li.cil.oc2.common.serialization.gson.MethodInvocationJsonDeserializer;
import li.cil.oc2.common.serialization.gson.RPCDeviceWithIdentifierJsonSerializer;
import li.cil.oc2.common.serialization.gson.RPCMethodJsonSerializer;
import li.cil.oc2.common.serialization.gson.UnsignedByteArrayJsonSerializer;
import li.cil.sedna.api.device.Steppable;
import li.cil.sedna.api.device.serial.SerialDevice;

public final class RPCDeviceBusAdapter
implements Steppable {
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 4096;
    private static final byte[] MESSAGE_DELIMITER = "\u0000".getBytes();
    public static final String ERROR_MESSAGE_TOO_LARGE = "message too large";
    public static final String ERROR_UNKNOWN_MESSAGE_TYPE = "unknown message type";
    public static final String ERROR_UNKNOWN_DEVICE = "unknown device";
    public static final String ERROR_UNKNOWN_METHOD = "unknown method";
    public static final String ERROR_INVALID_PARAMETER_SIGNATURE = "invalid parameter signature";
    private final SerialDevice serialDevice;
    private final Gson gson;
    private final ArrayList<RPCDeviceWithIdentifier> devicesWithId = new ArrayList();
    private final HashMap<UUID, RPCDeviceList> devicesById = new HashMap();
    private final Set<RPCDeviceList> unmountedDevices = new HashSet<RPCDeviceList>();
    private final Set<RPCDeviceList> mountedDevices = new HashSet<RPCDeviceList>();
    private final Lock pauseLock = new ReentrantLock();
    private boolean isPaused;
    @Serialized
    private final ByteBuffer transmitBuffer;
    @Serialized
    private ByteBuffer receiveBuffer;
    @Serialized
    private MethodInvocation synchronizedInvocation;

    public RPCDeviceBusAdapter(SerialDevice serialDevice) {
        this(serialDevice, 4096);
    }

    public RPCDeviceBusAdapter(SerialDevice serialDevice, int maxMessageSize) {
        this.serialDevice = serialDevice;
        this.transmitBuffer = ByteBuffer.allocate(maxMessageSize);
        this.gson = RPCMethodParameterTypeAdapters.beginBuildGson().registerTypeAdapter(byte[].class, (Object)new UnsignedByteArrayJsonSerializer()).registerTypeAdapter(MethodInvocation.class, (Object)new MethodInvocationJsonDeserializer()).registerTypeAdapter(Message.class, (Object)new MessageJsonDeserializer()).registerTypeAdapter(RPCDeviceWithIdentifier.class, (Object)new RPCDeviceWithIdentifierJsonSerializer()).registerTypeHierarchyAdapter(RPCMethod.class, (Object)new RPCMethodJsonSerializer()).registerTypeAdapter(EmptyMethodGroup.class, (Object)new EmptyRPCMethodGroupSerializer()).create();
    }

    public void mountDevices() {
        for (RPCDevice rPCDevice : this.unmountedDevices) {
            rPCDevice.mount();
        }
        this.mountedDevices.addAll(this.unmountedDevices);
        this.unmountedDevices.clear();
    }

    public void unmountDevices() {
        for (RPCDevice rPCDevice : this.mountedDevices) {
            rPCDevice.unmount();
        }
        this.unmountedDevices.addAll(this.mountedDevices);
        this.mountedDevices.clear();
    }

    public void disposeDevices() {
        this.unmountDevices();
        this.unmountedDevices.forEach(RPCDeviceList::dispose);
    }

    public void reset() {
        this.transmitBuffer.clear();
        this.receiveBuffer = null;
        this.synchronizedInvocation = null;
    }

    public void pause() {
        if (this.isPaused) {
            return;
        }
        this.pauseLock.lock();
        this.isPaused = true;
        this.pauseLock.unlock();
    }

    public void resume(DeviceBusController controller, boolean didDevicesChange) {
        this.isPaused = false;
        if (!didDevicesChange) {
            return;
        }
        HashMap<UUID, ArrayList> devicesByIdentifier = new HashMap<UUID, ArrayList>();
        for (Device device2 : controller.getDevices()) {
            if (!(device2 instanceof RPCDevice)) continue;
            RPCDevice rpcDevice = (RPCDevice)device2;
            Set<UUID> identifiers2 = controller.getDeviceIdentifiers(device2);
            for (UUID identifier2 : identifiers2) {
                devicesByIdentifier.computeIfAbsent(identifier2, unused -> new ArrayList()).add(rpcDevice);
            }
        }
        HashMap<RPCDeviceList, ArrayList> identifiersByDevice = new HashMap<RPCDeviceList, ArrayList>();
        devicesByIdentifier.forEach((identifier, devices) -> {
            RPCDeviceList device = new RPCDeviceList((ArrayList<RPCDevice>)devices);
            if (device.getMethodGroups().isEmpty()) {
                return;
            }
            identifiersByDevice.computeIfAbsent(device, unused -> new ArrayList()).add(identifier);
        });
        this.devicesWithId.clear();
        this.devicesById.clear();
        HashSet devices2 = new HashSet();
        identifiersByDevice.forEach((device, identifiers) -> {
            UUID identifier = this.selectIdentifierDeterministically((ArrayList<UUID>)identifiers);
            this.devicesWithId.add(new RPCDeviceWithIdentifier(identifier, (RPCDevice)device));
            this.devicesById.put(identifier, (RPCDeviceList)device);
            devices2.add(device);
            if (!this.mountedDevices.contains(device)) {
                this.unmountedDevices.add((RPCDeviceList)device);
            }
        });
        HashSet<RPCDeviceList> removedMountedDevices = new HashSet<RPCDeviceList>(this.mountedDevices);
        removedMountedDevices.removeAll(devices2);
        this.mountedDevices.removeAll(removedMountedDevices);
        removedMountedDevices.forEach(device -> {
            device.unmount();
            device.dispose();
        });
        HashSet<RPCDeviceList> removedUnmountedDevices = new HashSet<RPCDeviceList>(this.unmountedDevices);
        removedUnmountedDevices.removeAll(devices2);
        this.unmountedDevices.removeAll(removedUnmountedDevices);
        removedUnmountedDevices.forEach(RPCDeviceList::dispose);
    }

    public void tick() {
        if (this.isPaused) {
            return;
        }
        if (this.synchronizedInvocation != null) {
            MethodInvocation methodInvocation = this.synchronizedInvocation;
            this.processMethodInvocation(methodInvocation, true);
            this.synchronizedInvocation = null;
        }
    }

    public void step(int cycles) {
        if (this.isPaused || !this.pauseLock.tryLock()) {
            return;
        }
        try {
            this.readFromDevice();
            this.writeToDevice();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    private UUID selectIdentifierDeterministically(ArrayList<UUID> identifiers) {
        UUID lowestIdentifier = identifiers.get(0);
        for (int i = 1; i < identifiers.size(); ++i) {
            UUID identifier = identifiers.get(i);
            if (identifier.compareTo(lowestIdentifier) >= 0) continue;
            lowestIdentifier = identifier;
        }
        return lowestIdentifier;
    }

    private void readFromDevice() {
        int value;
        while (this.receiveBuffer == null && this.synchronizedInvocation == null && (value = this.serialDevice.read()) >= 0) {
            if (value == 0) {
                if (this.transmitBuffer.limit() > 0) {
                    this.transmitBuffer.flip();
                    if (this.transmitBuffer.hasRemaining()) {
                        byte[] message = new byte[this.transmitBuffer.remaining()];
                        this.transmitBuffer.get(message);
                        this.processMessage(message);
                    }
                } else {
                    this.writeError(ERROR_MESSAGE_TOO_LARGE);
                }
                this.transmitBuffer.clear();
                continue;
            }
            if (this.transmitBuffer.hasRemaining()) {
                this.transmitBuffer.put((byte)value);
                continue;
            }
            this.transmitBuffer.clear();
            this.transmitBuffer.limit(0);
        }
    }

    private void writeToDevice() {
        if (this.receiveBuffer == null) {
            return;
        }
        while (this.receiveBuffer.hasRemaining() && this.serialDevice.canPutByte()) {
            this.serialDevice.putByte(this.receiveBuffer.get());
        }
        this.serialDevice.flush();
        if (!this.receiveBuffer.hasRemaining()) {
            this.receiveBuffer = null;
        }
    }

    private void processMessage(byte[] messageData) {
        if (new String(messageData).trim().isEmpty()) {
            return;
        }
        InputStreamReader stream = new InputStreamReader(new ByteArrayInputStream(messageData));
        try {
            Message message = (Message)this.gson.fromJson((Reader)stream, Message.class);
            switch (message.type) {
                case "list": {
                    this.writeDeviceList();
                    break;
                }
                case "methods": {
                    if (message.data != null) {
                        this.writeDeviceMethods((UUID)message.data);
                        break;
                    }
                    this.writeError("missing device id");
                    break;
                }
                case "invoke": {
                    if (message.data != null) {
                        this.processMethodInvocation((MethodInvocation)message.data, false);
                        break;
                    }
                    this.writeError("missing invocation data");
                    break;
                }
                default: {
                    this.writeError(ERROR_UNKNOWN_MESSAGE_TYPE);
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.writeError(e.getMessage());
        }
    }

    private void processMethodInvocation(MethodInvocation methodInvocation, boolean isMainThread) {
        RPCDevice device = this.devicesById.get(methodInvocation.deviceId);
        if (device == null) {
            this.writeError(ERROR_UNKNOWN_DEVICE);
            return;
        }
        RPCInvocationImpl invocation = new RPCInvocationImpl(methodInvocation.parameters, this.gson);
        String error = ERROR_UNKNOWN_METHOD;
        for (RPCMethodGroup methodGroup : device.getMethodGroups()) {
            if (!Objects.equals(methodGroup.getName(), methodInvocation.methodName)) continue;
            Optional<RPCMethod> overload = methodGroup.findOverload(invocation);
            if (overload.isPresent()) {
                this.invokeMethod(methodInvocation, isMainThread, overload.get(), invocation);
                return;
            }
            error = ERROR_INVALID_PARAMETER_SIGNATURE;
        }
        this.writeError(error);
    }

    private void invokeMethod(MethodInvocation methodInvocation, boolean isMainThread, RPCMethod method, RPCInvocation invocation) {
        if (method.isSynchronized() && !isMainThread) {
            this.synchronizedInvocation = methodInvocation;
            return;
        }
        try {
            Object result = method.invoke(invocation);
            this.writeMessage("result", result);
        }
        catch (Throwable e) {
            this.writeError(e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName());
        }
    }

    private void writeDeviceList() {
        this.writeMessage("list", this.devicesWithId);
    }

    private void writeDeviceMethods(UUID deviceId) {
        RPCDeviceList device = this.devicesById.get(deviceId);
        if (device != null) {
            this.writeMessage("methods", this.flattenMethodGroups(device.getMethodGroups()));
        } else {
            this.writeError(ERROR_UNKNOWN_DEVICE);
        }
    }

    private List<Object> flattenMethodGroups(List<? extends RPCMethodGroup> methodGroups) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (RPCMethodGroup rPCMethodGroup : methodGroups) {
            Set<RPCMethod> overloads = rPCMethodGroup.getOverloads();
            if (overloads.isEmpty()) {
                result.add(new EmptyMethodGroup(rPCMethodGroup.getName()));
                continue;
            }
            result.addAll(overloads);
        }
        return result;
    }

    private void writeError(String message) {
        this.writeMessage("error", message);
    }

    private void writeMessage(String type, @Nullable Object data) {
        if (this.receiveBuffer != null) {
            throw new IllegalStateException();
        }
        String json = this.gson.toJson((Object)new Message(type, data));
        byte[] bytes = json.getBytes();
        ByteBuffer receiveBuffer = ByteBuffer.allocate(bytes.length + MESSAGE_DELIMITER.length * 2);
        receiveBuffer.put(MESSAGE_DELIMITER);
        receiveBuffer.put(bytes);
        receiveBuffer.put(MESSAGE_DELIMITER);
        receiveBuffer.flip();
        this.receiveBuffer = receiveBuffer;
    }

    @Serialized
    public static final class MethodInvocation {
        public UUID deviceId;
        public String methodName;
        public JsonArray parameters;

        public MethodInvocation() {
        }

        public MethodInvocation(UUID deviceId, String methodName, JsonArray parameters) {
            this.deviceId = deviceId;
            this.methodName = methodName;
            this.parameters = parameters;
        }
    }

    public record Message(String type, @Nullable Object data) {
        public static final String MESSAGE_TYPE_LIST = "list";
        public static final String MESSAGE_TYPE_METHODS = "methods";
        public static final String MESSAGE_TYPE_RESULT = "result";
        public static final String MESSAGE_TYPE_ERROR = "error";
        public static final String MESSAGE_TYPE_INVOKE_METHOD = "invoke";
    }

    public record RPCDeviceWithIdentifier(UUID identifier, RPCDevice device) {
    }

    public record EmptyMethodGroup(String name) {
    }

    private record RPCInvocationImpl(JsonArray parameters, Gson gson) implements RPCInvocation
    {
        @Override
        public JsonArray getParameters() {
            return this.parameters;
        }

        @Override
        public Gson getGson() {
            return this.gson;
        }

        @Override
        public Optional<Object[]> tryDeserializeParameters(RPCParameter ... parameterTypes) {
            if (parameterTypes.length != this.parameters.size()) {
                return Optional.empty();
            }
            Object[] result = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                RPCParameter parameterInfo = parameterTypes[i];
                try {
                    result[i] = this.gson.fromJson(this.parameters.get(i), parameterInfo.getType());
                    continue;
                }
                catch (Throwable e) {
                    return Optional.empty();
                }
            }
            return Optional.of(result);
        }
    }
}

