/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.provider.ItemDeviceProvider;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.api.bus.device.rpc.RPCDevice;
import li.cil.oc2.common.bus.AbstractGroupingDeviceBusElement;
import li.cil.oc2.common.bus.device.provider.Providers;
import li.cil.oc2.common.bus.device.rpc.TypeNameRPCDevice;
import li.cil.oc2.common.bus.device.util.Devices;
import li.cil.oc2.common.bus.device.util.ItemDeviceInfo;
import li.cil.oc2.common.util.ItemDeviceUtils;
import li.cil.oc2.common.util.RegistryUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistry;

public final class ItemHandlerDeviceBusElement
extends AbstractGroupingDeviceBusElement<ItemEntry, ItemDeviceQuery> {
    private final Function<ItemStack, ItemDeviceQuery> queryFactory;

    public ItemHandlerDeviceBusElement(int slotCount, Function<ItemStack, ItemDeviceQuery> queryFactory) {
        super(slotCount);
        this.queryFactory = queryFactory;
    }

    public boolean groupContains(int groupIndex, Device device) {
        for (ItemEntry entry : (HashSet)this.groups.get(groupIndex)) {
            if (!Objects.equals(entry.getDevice(), device)) continue;
            return true;
        }
        return false;
    }

    public void updateDevices(int slot, ItemStack stack) {
        if (!stack.m_41619_()) {
            ItemDeviceQuery query = this.queryFactory.apply(stack);
            HashSet<ItemEntry> newDevices = new HashSet<ItemEntry>(Devices.getDevices(query).stream().map(ItemEntry::new).toList());
            this.insertItemNameDevice(stack, newDevices);
            this.importDeviceDataFromItemStack(stack, newDevices);
            this.setEntriesForGroup(slot, new ItemQueryResult(query, newDevices));
        } else {
            this.setEntriesForGroup(slot, new ItemQueryResult(null, Collections.emptySet()));
        }
    }

    public void exportDeviceDataToItemStack(int slot, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        CompoundTag exportedTag = new CompoundTag();
        for (ItemEntry entry : (HashSet)this.groups.get(slot)) {
            entry.getDeviceDataKey().ifPresent(key -> {
                CompoundTag deviceTag = new CompoundTag();
                entry.getDevice().exportToItemStack(deviceTag);
                if (!deviceTag.m_128456_()) {
                    exportedTag.m_128365_(key, (Tag)deviceTag);
                }
            });
        }
        if (!exportedTag.m_128456_()) {
            ItemDeviceUtils.setItemDeviceData(stack, exportedTag);
        }
    }

    @Override
    protected void onEntryRemoved(String dataKey, CompoundTag tag, @Nullable ItemDeviceQuery query) {
        super.onEntryRemoved(dataKey, tag, query);
        IForgeRegistry<ItemDeviceProvider> registry = Providers.ITEM_DEVICE_PROVIDER_REGISTRY.get();
        ItemDeviceProvider provider = (ItemDeviceProvider)registry.getValue(new ResourceLocation(dataKey));
        if (provider != null) {
            provider.unmount(query, tag);
        }
    }

    private void importDeviceDataFromItemStack(ItemStack stack, HashSet<ItemEntry> entries) {
        CompoundTag exportedTag = ItemDeviceUtils.getItemDeviceData(stack);
        if (!exportedTag.m_128456_()) {
            for (ItemEntry entry : entries) {
                entry.getDeviceDataKey().ifPresent(key -> {
                    if (exportedTag.m_128425_(key, 10)) {
                        ((ItemDevice)entry.deviceInfo.device).importFromItemStack(exportedTag.m_128469_(key));
                    }
                });
            }
        }
    }

    private void insertItemNameDevice(ItemStack stack, HashSet<ItemEntry> entries) {
        ResourceLocation registryName;
        if (entries.stream().anyMatch(entry -> entry.getDevice() instanceof RPCDevice) && (registryName = stack.m_41720_().getRegistryName()) != null) {
            entries.add(new ItemEntry(new ItemDeviceInfo(null, new TypeNameRPCDevice(registryName.toString()), 0)));
        }
    }

    protected record ItemEntry(ItemDeviceInfo deviceInfo) implements AbstractGroupingDeviceBusElement.Entry
    {
        @Override
        public Optional<String> getDeviceDataKey() {
            return RegistryUtils.optionalKey(this.deviceInfo.provider);
        }

        @Override
        public OptionalInt getDeviceEnergyConsumption() {
            return OptionalInt.of(this.deviceInfo.getEnergyConsumption());
        }

        @Override
        public ItemDevice getDevice() {
            return (ItemDevice)this.deviceInfo.device;
        }
    }

    protected final class ItemQueryResult
    extends AbstractGroupingDeviceBusElement.QueryResult {
        @Nullable
        private final ItemDeviceQuery query;
        private final Set<ItemEntry> entries;

        public ItemQueryResult(ItemDeviceQuery query, Set<ItemEntry> entries) {
            super(ItemHandlerDeviceBusElement.this);
            this.query = query;
            this.entries = entries;
        }

        @Nullable
        public ItemDeviceQuery getQuery() {
            return this.query;
        }

        public Set<ItemEntry> getEntries() {
            return this.entries;
        }
    }
}

