/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.BlockDeviceBusElement;
import li.cil.oc2.api.bus.DeviceBus;
import li.cil.oc2.api.bus.DeviceBusElement;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.provider.BlockDeviceProvider;
import li.cil.oc2.api.bus.device.provider.BlockDeviceQuery;
import li.cil.oc2.api.util.Invalidatable;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.bus.AbstractGroupingDeviceBusElement;
import li.cil.oc2.common.bus.device.provider.Providers;
import li.cil.oc2.common.bus.device.rpc.TypeNameRPCDevice;
import li.cil.oc2.common.bus.device.util.BlockDeviceInfo;
import li.cil.oc2.common.bus.device.util.Devices;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.util.LevelUtils;
import li.cil.oc2.common.util.RegistryUtils;
import li.cil.oc2.common.util.ServerScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.IForgeRegistry;

public class BlockEntityDeviceBusElement
extends AbstractGroupingDeviceBusElement<BlockEntry, BlockDeviceQuery>
implements BlockDeviceBusElement {
    private final BlockEntity blockEntity;

    public BlockEntityDeviceBusElement(BlockEntity blockEntity) {
        super(Constants.BLOCK_FACE_COUNT);
        this.blockEntity = blockEntity;
    }

    @Override
    @Nullable
    public LevelAccessor getLevel() {
        return this.blockEntity.m_58904_();
    }

    @Override
    public BlockPos getPosition() {
        return this.blockEntity.m_58899_();
    }

    @Override
    public Optional<Collection<LazyOptional<DeviceBusElement>>> getNeighbors() {
        Level level = this.blockEntity.m_58904_();
        if (level == null || level.m_5776_()) {
            return Optional.empty();
        }
        ArrayList<LazyOptional> neighbors = new ArrayList<LazyOptional>();
        for (Direction neighborDirection : Constants.DIRECTIONS) {
            LazyOptional capability;
            if (!this.canScanContinueTowards(neighborDirection)) continue;
            BlockPos neighborPos = this.blockEntity.m_58899_().m_142300_(neighborDirection);
            ChunkPos chunkPos = new ChunkPos(neighborPos);
            if (!level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
                return Optional.empty();
            }
            BlockEntity blockEntity = level.m_7702_(neighborPos);
            if (blockEntity == null || !(capability = blockEntity.getCapability(Capabilities.DEVICE_BUS_ELEMENT, neighborDirection.m_122424_())).isPresent()) continue;
            neighbors.add(capability);
        }
        return Optional.of(neighbors);
    }

    public void handleNeighborChanged(BlockPos pos) {
        Level level = this.blockEntity.m_58904_();
        if (level == null || level.m_5776_() || !level.m_46749_(pos)) {
            return;
        }
        BlockPos toPos = pos.m_141950_((Vec3i)this.blockEntity.m_58899_());
        Direction direction = Direction.m_122378_((int)toPos.m_123341_(), (int)toPos.m_123342_(), (int)toPos.m_123343_());
        if (direction == null) {
            return;
        }
        BlockQueryResult queryResult = this.collectDevices(level, pos, direction);
        int index = direction.m_122411_();
        this.setEntriesForGroup(index, queryResult);
    }

    public void initialize() {
        Level level = Objects.requireNonNull(this.blockEntity.m_58904_());
        ServerScheduler.schedule((LevelAccessor)level, () -> {
            if (this.blockEntity.m_58901_()) {
                return;
            }
            this.scanNeighborsForDevices();
            this.scheduleBusScanInAdjacentBusElements();
        });
    }

    protected boolean canScanContinueTowards(@Nullable Direction direction) {
        return true;
    }

    protected boolean canDetectDevicesTowards(@Nullable Direction direction) {
        return this.canScanContinueTowards(direction);
    }

    protected BlockQueryResult collectDevices(Level level, BlockPos pos, @Nullable Direction direction) {
        BlockDeviceQuery query = Devices.makeQuery(level, pos, direction != null ? direction.m_122424_() : null);
        HashSet<BlockEntry> entries = new HashSet<BlockEntry>();
        if (this.canDetectDevicesTowards(direction)) {
            for (Invalidatable<BlockDeviceInfo> deviceInfo : Devices.getDevices(query)) {
                if (!deviceInfo.isPresent()) continue;
                entries.add(new BlockEntry(deviceInfo, pos));
            }
            this.collectSyntheticDevices(level, pos, direction, entries);
        }
        return new BlockQueryResult(query, entries);
    }

    protected void collectSyntheticDevices(Level level, BlockPos pos, @Nullable Direction direction, HashSet<BlockEntry> entries) {
        String blockName = LevelUtils.getBlockName((LevelAccessor)level, pos);
        if (blockName != null) {
            entries.add(new BlockEntry(new BlockDeviceInfo(null, new TypeNameRPCDevice(blockName)), pos));
        }
    }

    @Override
    protected void onEntryAdded(BlockEntry entry) {
        super.onEntryAdded(entry);
        entry.addListener();
    }

    @Override
    protected void onEntryRemoved(BlockEntry entry) {
        super.onEntryRemoved(entry);
        entry.removeListener();
    }

    @Override
    protected void onEntryRemoved(String dataKey, CompoundTag tag, @Nullable BlockDeviceQuery query) {
        assert (query != null) : "Passed null query for block device bus element.";
        super.onEntryRemoved(dataKey, tag, query);
        IForgeRegistry<BlockDeviceProvider> registry = Providers.BLOCK_DEVICE_PROVIDER_REGISTRY.get();
        BlockDeviceProvider provider = (BlockDeviceProvider)registry.getValue(new ResourceLocation(dataKey));
        if (provider != null) {
            provider.unmount(query, tag);
        }
    }

    private void scanNeighborsForDevices() {
        for (Direction direction : Constants.DIRECTIONS) {
            this.handleNeighborChanged(this.blockEntity.m_58899_().m_142300_(direction));
        }
    }

    private void scheduleBusScanInAdjacentBusElements() {
        Level level = Objects.requireNonNull(this.blockEntity.m_58904_());
        BlockPos pos = this.blockEntity.m_58899_();
        for (Direction direction : Constants.DIRECTIONS) {
            BlockPos neighborPos = pos.m_142300_(direction);
            BlockEntity blockEntity = LevelUtils.getBlockEntityIfChunkExists((LevelAccessor)level, neighborPos);
            if (blockEntity == null) continue;
            LazyOptional capability = blockEntity.getCapability(Capabilities.DEVICE_BUS_ELEMENT, direction.m_122424_());
            capability.ifPresent(DeviceBus::scheduleScan);
        }
    }

    protected final class BlockQueryResult
    extends AbstractGroupingDeviceBusElement.QueryResult {
        private final BlockDeviceQuery query;
        private final Set<BlockEntry> entries;

        public BlockQueryResult(BlockDeviceQuery query, Set<BlockEntry> entries) {
            super(BlockEntityDeviceBusElement.this);
            this.query = query;
            this.entries = entries;
        }

        public BlockDeviceQuery getQuery() {
            return this.query;
        }

        public Set<BlockEntry> getEntries() {
            return this.entries;
        }
    }

    protected final class BlockEntry
    implements AbstractGroupingDeviceBusElement.Entry {
        private final Invalidatable<BlockDeviceInfo> deviceInfo;
        @Nullable
        private final String dataKey;
        private final Device device;
        private final BlockPos pos;
        private Invalidatable.ListenerToken token;

        public BlockEntry(Invalidatable<BlockDeviceInfo> deviceInfo, BlockPos pos) {
            this.deviceInfo = deviceInfo;
            this.pos = pos;
            this.dataKey = RegistryUtils.optionalKey(deviceInfo.get().provider).orElse(null);
            this.device = deviceInfo.get().device;
        }

        public BlockEntry(BlockDeviceInfo deviceInfo, BlockPos pos) {
            this(Invalidatable.of(deviceInfo), pos);
        }

        @Override
        public Optional<String> getDeviceDataKey() {
            return Optional.ofNullable(this.dataKey);
        }

        @Override
        public OptionalInt getDeviceEnergyConsumption() {
            return this.deviceInfo.isPresent() ? OptionalInt.of(this.deviceInfo.get().getEnergyConsumption()) : OptionalInt.empty();
        }

        @Override
        public Device getDevice() {
            return this.device;
        }

        public void addListener() {
            if (this.token == null) {
                this.token = this.deviceInfo.addListener(unused -> BlockEntityDeviceBusElement.this.handleNeighborChanged(this.pos));
            }
        }

        public void removeListener() {
            if (this.token != null) {
                this.token.removeListener();
                this.token = null;
            }
        }
    }
}

