/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import li.cil.oc2.api.bus.BlockDeviceBusElement;
import li.cil.oc2.api.bus.DeviceBusElement;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.util.ServerScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class BlockEntityDeviceBusController
extends CommonDeviceBusController {
    private final Runnable onBusChunkLoadedStateChanged = this::scheduleBusScan;
    private final HashSet<TrackedChunk> trackedChunks = new HashSet();
    private final BlockEntity blockEntity;

    public BlockEntityDeviceBusController(DeviceBusElement root, int baseEnergyConsumption, BlockEntity blockEntity) {
        super(root, baseEnergyConsumption);
        this.blockEntity = blockEntity;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeListeners(this.trackedChunks);
        this.trackedChunks.clear();
    }

    @Override
    protected void onAfterBusScan() {
        super.onAfterBusScan();
        Level level = this.blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        HashSet<TrackedChunk> newTrackedChunks = new HashSet<TrackedChunk>();
        for (DeviceBusElement element : this.getElements()) {
            if (!(element instanceof BlockDeviceBusElement)) continue;
            BlockDeviceBusElement blockElement = (BlockDeviceBusElement)element;
            LevelAccessor elementLevel = blockElement.getLevel();
            BlockPos elementPosition = blockElement.getPosition();
            if (elementLevel == null) continue;
            newTrackedChunks.add(TrackedChunk.of(elementLevel, elementPosition));
            newTrackedChunks.add(TrackedChunk.of(elementLevel, elementPosition.m_142300_(Direction.NORTH)));
            newTrackedChunks.add(TrackedChunk.of(elementLevel, elementPosition.m_142300_(Direction.EAST)));
            newTrackedChunks.add(TrackedChunk.of(elementLevel, elementPosition.m_142300_(Direction.SOUTH)));
            newTrackedChunks.add(TrackedChunk.of(elementLevel, elementPosition.m_142300_(Direction.WEST)));
        }
        newTrackedChunks.remove(TrackedChunk.of((LevelAccessor)level, this.blockEntity.m_58899_()));
        HashSet<TrackedChunk> removedChunks = new HashSet<TrackedChunk>(this.trackedChunks);
        removedChunks.removeAll(newTrackedChunks);
        this.removeListeners(removedChunks);
        HashSet<TrackedChunk> addedChunks = new HashSet<TrackedChunk>(newTrackedChunks);
        newTrackedChunks.removeAll(this.trackedChunks);
        this.addListeners(addedChunks);
        this.trackedChunks.removeAll(removedChunks);
        this.trackedChunks.addAll(newTrackedChunks);
    }

    private void addListeners(Collection<TrackedChunk> trackedChunks) {
        for (TrackedChunk trackedChunk : trackedChunks) {
            trackedChunk.tryGetLevel().ifPresent(level -> {
                ServerScheduler.scheduleOnLoad(level, trackedChunk.position, this.onBusChunkLoadedStateChanged);
                ServerScheduler.scheduleOnUnload(level, trackedChunk.position, this.onBusChunkLoadedStateChanged);
            });
        }
    }

    private void removeListeners(Collection<TrackedChunk> trackedChunks) {
        for (TrackedChunk trackedChunk : trackedChunks) {
            trackedChunk.tryGetLevel().ifPresent(level -> {
                ServerScheduler.cancelOnLoad(level, trackedChunk.position, this.onBusChunkLoadedStateChanged);
                ServerScheduler.cancelOnUnload(level, trackedChunk.position, this.onBusChunkLoadedStateChanged);
            });
        }
    }

    private record TrackedChunk(WeakReference<LevelAccessor> level, ChunkPos position) {
        public static TrackedChunk of(LevelAccessor level, BlockPos position) {
            return new TrackedChunk(new WeakReference<LevelAccessor>(level), new ChunkPos(position));
        }

        public Optional<LevelAccessor> tryGetLevel() {
            return Optional.ofNullable((LevelAccessor)this.level.get());
        }
    }
}

