/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.blockentity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.vm.VMDevice;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.block.DiskDriveBlock;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.ModBlockEntity;
import li.cil.oc2.common.bus.device.item.AbstractBlockDeviceVMDevice;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.container.TypedItemStackHandler;
import li.cil.oc2.common.item.FloppyItem;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.DiskDriveFloppyMessage;
import li.cil.oc2.common.serialization.BlobStorage;
import li.cil.oc2.common.tags.ItemTags;
import li.cil.oc2.common.util.ItemStackUtils;
import li.cil.oc2.common.util.LocationSupplierUtils;
import li.cil.oc2.common.util.SoundEvents;
import li.cil.oc2.common.util.ThrottledSoundEmitter;
import li.cil.sedna.api.device.BlockDevice;
import li.cil.sedna.device.block.ByteBufferBlockDevice;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class DiskDriveBlockEntity
extends ModBlockEntity {
    private static final String DATA_TAG_NAME = "data";
    private static final ByteBufferBlockDevice EMPTY_BLOCK_DEVICE = ByteBufferBlockDevice.create((int)0, (boolean)false);
    private final DiskDriveItemStackHandler itemHandler = new DiskDriveItemStackHandler();
    private final DiskDriveVMDevice device = new DiskDriveVMDevice();
    private final ThrottledSoundEmitter accessSoundEmitter = new ThrottledSoundEmitter(LocationSupplierUtils.of(this), (SoundEvent)SoundEvents.FLOPPY_ACCESS.get()).withMinInterval(Duration.ofSeconds(1L));
    private final ThrottledSoundEmitter insertSoundEmitter = new ThrottledSoundEmitter(LocationSupplierUtils.of(this), (SoundEvent)SoundEvents.FLOPPY_INSERT.get()).withMinInterval(Duration.ofMillis(100L));
    private final ThrottledSoundEmitter ejectSoundEmitter = new ThrottledSoundEmitter(LocationSupplierUtils.of(this), (SoundEvent)SoundEvents.FLOPPY_EJECT.get()).withMinInterval(Duration.ofMillis(100L));

    public DiskDriveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.DISK_DRIVE.get(), pos, state);
    }

    public VMDevice getDevice() {
        return this.device;
    }

    public boolean canInsert(ItemStack stack) {
        return !stack.m_41619_() && ItemTags.DEVICES_FLOPPY.m_8110_((Object)stack.m_41720_());
    }

    public ItemStack insert(ItemStack stack, @Nullable Player player) {
        if (stack.m_41619_() || !ItemTags.DEVICES_FLOPPY.m_8110_((Object)stack.m_41720_())) {
            return stack;
        }
        this.eject(player);
        this.insertSoundEmitter.play();
        return this.itemHandler.insertItem(0, stack, false);
    }

    public boolean canEject() {
        return !this.itemHandler.extractItem(0, 1, true).m_41619_();
    }

    public void eject(@Nullable Player player) {
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack stack = this.itemHandler.extractItem(0, 1, false);
        if (!stack.m_41619_()) {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)DiskDriveBlock.f_54117_);
            this.ejectSoundEmitter.play();
            ItemStackUtils.spawnAsEntity(this.f_58857_, this.m_58899_().m_142300_(facing), stack, facing).ifPresent(entity -> {
                if (player != null) {
                    entity.m_32061_();
                    entity.m_32047_(player.m_142081_());
                }
            });
        }
    }

    public ItemStack getFloppy() {
        return this.itemHandler.getStackInSlot(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setFloppyClient(ItemStack stack) {
        this.itemHandler.setStackInSlot(0, stack);
    }

    @Override
    protected void collectCapabilities(ModBlockEntity.CapabilityCollector collector, @Nullable Direction direction) {
        collector.offer(Capabilities.ITEM_HANDLER, this.itemHandler);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("items", (net.minecraft.nbt.Tag)this.itemHandler.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("items"));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("items", (net.minecraft.nbt.Tag)this.itemHandler.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("items"));
    }

    private final class DiskDriveItemStackHandler
    extends TypedItemStackHandler {
        public DiskDriveItemStackHandler() {
            super(1, (Tag<Item>)ItemTags.DEVICES_FLOPPY);
        }

        public ItemStack getStackInSlotRaw(int slot) {
            return super.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            ItemStack stack = this.getStackInSlotRaw(slot);
            this.exportDeviceDataToItemStack(stack);
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0 && !simulate && amount > 0) {
                this.exportDeviceDataToItemStack(this.getStackInSlotRaw(0));
            }
            return super.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public CompoundTag serializeNBT() {
            this.exportDeviceDataToItemStack(this.getStackInSlotRaw(0));
            return super.serializeNBT();
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (DiskDriveBlockEntity.this.f_58857_ == null || DiskDriveBlockEntity.this.f_58857_.m_5776_()) {
                return;
            }
            ItemStack stack = this.getStackInSlotRaw(slot);
            if (stack.m_41619_()) {
                DiskDriveBlockEntity.this.device.removeBlockDevice();
            } else {
                CompoundTag tag = ItemStackUtils.getOrCreateModDataTag(stack).m_128469_(DiskDriveBlockEntity.DATA_TAG_NAME);
                DiskDriveBlockEntity.this.device.updateBlockDevice(tag);
            }
            Network.sendToClientsTrackingBlockEntity(new DiskDriveFloppyMessage(DiskDriveBlockEntity.this), DiskDriveBlockEntity.this);
            DiskDriveBlockEntity.this.m_6596_();
        }

        private void exportDeviceDataToItemStack(ItemStack stack) {
            if (stack.m_41619_()) {
                return;
            }
            if (DiskDriveBlockEntity.this.f_58857_ == null || DiskDriveBlockEntity.this.f_58857_.m_5776_()) {
                return;
            }
            CompoundTag tag = new CompoundTag();
            DiskDriveBlockEntity.this.device.exportToItemStack(tag);
            ItemStackUtils.getOrCreateModDataTag(stack).m_128365_(DiskDriveBlockEntity.DATA_TAG_NAME, (net.minecraft.nbt.Tag)tag);
        }
    }

    private final class DiskDriveVMDevice
    extends AbstractBlockDeviceVMDevice<BlockDevice, BlockEntity> {
        public DiskDriveVMDevice() {
            super(DiskDriveBlockEntity.this, false);
        }

        public void updateBlockDevice(CompoundTag tag) {
            this.joinOpenJob();
            if (this.device == null) {
                return;
            }
            try {
                this.device.setBlock((BlockDevice)EMPTY_BLOCK_DEVICE);
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
            if (this.blobHandle != null) {
                BlobStorage.close(this.blobHandle);
                this.blobHandle = null;
            }
            this.importFromItemStack(tag);
            this.setOpenJob((CompletableFuture<Void>)this.createBlockDevice().thenAcceptAsync(blockDevice -> {
                try {
                    this.device.setBlock(blockDevice);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, (Executor)WORKERS));
        }

        public void removeBlockDevice() {
            this.joinOpenJob();
            if (this.device == null) {
                return;
            }
            try {
                this.device.setBlock((BlockDevice)EMPTY_BLOCK_DEVICE);
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
            if (this.blobHandle != null) {
                BlobStorage.close(this.blobHandle);
                this.blobHandle = null;
            }
        }

        @Override
        protected CompletableFuture<BlockDevice> createBlockDevice() {
            Item item;
            ItemStack stack = DiskDriveBlockEntity.this.itemHandler.getStackInSlotRaw(0);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof FloppyItem)) {
                return CompletableFuture.completedFuture(EMPTY_BLOCK_DEVICE);
            }
            FloppyItem floppy = (FloppyItem)item;
            int capacity = Mth.m_14045_((int)floppy.getCapacity(stack), (int)0, (int)Config.maxFloppySize);
            if (capacity <= 0) {
                return CompletableFuture.completedFuture(EMPTY_BLOCK_DEVICE);
            }
            this.blobHandle = BlobStorage.validateHandle(this.blobHandle);
            return CompletableFuture.supplyAsync(() -> {
                try {
                    FileChannel channel = BlobStorage.getOrOpen(this.blobHandle);
                    MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, capacity);
                    return ByteBufferBlockDevice.wrap((ByteBuffer)buffer, (boolean)false);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, WORKERS);
        }

        @Override
        protected void handleDataAccess() {
            DiskDriveBlockEntity.this.accessSoundEmitter.play();
        }
    }
}

