/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.blockentity;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.NamedDevice;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.ModBlockEntity;
import li.cil.oc2.common.blockentity.TickableBlockEntity;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.energy.FixedEnergyStorage;
import li.cil.oc2.common.util.ChunkUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public final class ChargerBlockEntity
extends ModBlockEntity
implements NamedDevice,
TickableBlockEntity {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(EntitySelector.f_20402_);
    private final FixedEnergyStorage energy = new FixedEnergyStorage(Config.chargerEnergyStorage);
    private boolean isCharging;

    ChargerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.CHARGER.get(), pos, state);
    }

    @Override
    public void clientTick() {
        this.tick();
    }

    @Override
    public void serverTick() {
        this.tick();
    }

    private void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        this.isCharging = false;
        this.chargeBlock();
        this.chargeEntities();
        if (this.isCharging) {
            ChunkUtils.setLazyUnsaved(this.f_58857_, this.m_58899_());
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
    }

    @Callback
    public boolean isCharging() {
        return this.isCharging;
    }

    @Override
    public Collection<String> getDeviceTypeNames() {
        return Collections.singletonList("charger");
    }

    @Override
    protected void collectCapabilities(ModBlockEntity.CapabilityCollector collector, @Nullable Direction direction) {
        collector.offer(Capabilities.ENERGY_STORAGE, this.energy);
    }

    private void chargeBlock() {
        assert (this.f_58857_ != null);
        if (this.energy.getEnergyStored() == 0) {
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_7494_());
        if (blockEntity != null) {
            this.chargeCapabilityProvider((ICapabilityProvider)blockEntity);
        }
    }

    private void chargeEntities() {
        assert (this.f_58857_ != null);
        if (this.energy.getEnergyStored() == 0) {
            return;
        }
        List entities = this.f_58857_.m_6249_((Entity)null, new AABB(this.m_58899_().m_7494_()), ENTITY_PREDICATE);
        for (Entity entity : entities) {
            this.chargeCapabilityProvider((ICapabilityProvider)entity);
        }
    }

    private void chargeCapabilityProvider(ICapabilityProvider capabilityProvider) {
        capabilityProvider.getCapability(Capabilities.ENERGY_STORAGE, Direction.DOWN).ifPresent(this::charge);
        capabilityProvider.getCapability(Capabilities.ITEM_HANDLER, Direction.DOWN).ifPresent(this::chargeItems);
    }

    private void chargeItems(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            stack.getCapability(Capabilities.ENERGY_STORAGE).ifPresent(this::charge);
        }
    }

    private void charge(IEnergyStorage energyStorage) {
        boolean simulate;
        assert (this.f_58857_ != null);
        int amount = Math.min(this.energy.getEnergyStored(), Config.chargerEnergyPerTick);
        if (this.energy.extractEnergy(energyStorage.receiveEnergy(amount, simulate = this.f_58857_.f_46443_), simulate) > 0) {
            this.isCharging = true;
        }
    }
}

