/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import li.cil.oc2.client.renderer.ModRenderType;
import li.cil.oc2.common.blockentity.NetworkConnectorBlockEntity;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public final class NetworkCableRenderer {
    private static final int MAX_RENDER_DISTANCE = 100;
    private static final int CABLE_VERTEX_COUNT = 9;
    private static final float CABLE_THICKNESS = 0.025f;
    private static final float CABLE_LENGTH_FOR_MAX_SWING = 6.0f;
    private static final float CABLE_MAX_SWING_AMOUNT = 0.05f;
    private static final int CABLE_SWING_INTERVAL = 8000;
    private static final float CABLE_HANG_MIN = 0.1f;
    private static final float CABLE_HANG_MAX = 0.5f;
    private static final float CABLE_MAX_LENGTH = 8.0f;
    private static final Vector3f CABLE_COLOR = new Vector3f(0.0f, 0.33f, 0.4f);
    private static final Set<NetworkConnectorBlockEntity> connectors = Collections.newSetFromMap(new WeakHashMap());
    private static int lastKnownConnectorCount;
    private static boolean isDirty;
    private static final ArrayList<Connection> connections;
    private static final WeakHashMap<NetworkConnectorBlockEntity, ArrayList<Connection>> connectionsByConnector;
    private static final ArrayList<CablePoint> cablePoints;

    public static void initialize() {
        MinecraftForge.EVENT_BUS.addListener(NetworkCableRenderer::handleRenderWorld);
        MinecraftForge.EVENT_BUS.addListener(NetworkCableRenderer::handleChunkUnloadEvent);
        MinecraftForge.EVENT_BUS.addListener(NetworkCableRenderer::handleWorldUnloadEvent);
    }

    public static void addNetworkConnector(NetworkConnectorBlockEntity connector) {
        connectors.add(connector);
        NetworkCableRenderer.invalidateConnections();
    }

    public static void invalidateConnections() {
        isDirty = true;
    }

    public static void renderCablesFor(BlockAndTintGetter level, PoseStack stack, Vec3 eye, NetworkConnectorBlockEntity connector) {
        ArrayList<Connection> connections = connectionsByConnector.get(connector);
        if (connections != null) {
            NetworkCableRenderer.renderCables(level, stack, eye, connections, unused -> true);
        }
    }

    private static void handleChunkUnloadEvent(ChunkEvent.Unload event) {
        if (event.getWorld().m_5776_()) {
            ChunkPos chunkPos = event.getChunk().m_7697_();
            ArrayList<NetworkConnectorBlockEntity> list = new ArrayList<NetworkConnectorBlockEntity>(connectors);
            for (NetworkConnectorBlockEntity connector : list) {
                ChunkPos connectorChunkPos = new ChunkPos(connector.m_58899_());
                if (!Objects.equals(connectorChunkPos, chunkPos)) continue;
                connectors.remove(connector);
            }
            NetworkCableRenderer.invalidateConnections();
        }
    }

    private static void handleWorldUnloadEvent(WorldEvent.Unload event) {
        if (event.getWorld().m_5776_()) {
            LevelAccessor level = event.getWorld();
            ArrayList<NetworkConnectorBlockEntity> list = new ArrayList<NetworkConnectorBlockEntity>(connectors);
            for (NetworkConnectorBlockEntity connector : list) {
                if (connector.m_58904_() != level) continue;
                connectors.remove(connector);
            }
            NetworkCableRenderer.invalidateConnections();
        }
    }

    private static void handleRenderWorld(RenderLevelLastEvent event) {
        NetworkCableRenderer.validateConnectors();
        NetworkCableRenderer.validatePairs();
        if (Minecraft.m_91085_()) {
            return;
        }
        if (connections.isEmpty()) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        ClientLevel level = client.f_91073_;
        if (level == null) {
            return;
        }
        PoseStack stack = event.getPoseStack();
        Camera activeRenderInfo = client.f_91063_.m_109153_();
        Vec3 eye = activeRenderInfo.m_90583_();
        Frustum frustum = new Frustum(stack.m_85850_().m_85861_(), event.getProjectionMatrix());
        frustum.m_113002_(eye.f_82479_, eye.f_82480_, eye.f_82481_);
        stack.m_85836_();
        stack.m_85837_(-eye.f_82479_, -eye.f_82480_, -eye.f_82481_);
        NetworkCableRenderer.renderCables((BlockAndTintGetter)level, stack, eye, connections, arg_0 -> ((Frustum)frustum).m_113029_(arg_0));
        stack.m_85849_();
    }

    private static void renderCables(BlockAndTintGetter level, PoseStack stack, Vec3 eye, ArrayList<Connection> connections, Predicate<AABB> filter) {
        Matrix4f viewMatrix = stack.m_85850_().m_85861_();
        RenderType renderType = ModRenderType.getNetworkCable();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        float r = CABLE_COLOR.m_122239_();
        float g = CABLE_COLOR.m_122260_();
        float b = CABLE_COLOR.m_122269_();
        for (Connection connection : connections) {
            int i;
            Vec3 p0 = connection.from;
            Vec3 p1 = connection.to;
            if (!p0.m_82509_((Position)eye, 100.0) && !p1.m_82509_((Position)eye, 100.0) || !filter.test(connection.bounds)) continue;
            Vec3 p2 = NetworkCableRenderer.animateCableSwing(NetworkCableRenderer.lerp(p0, p1, 0.5f).m_82492_(0.0, (double)NetworkCableRenderer.computeCableHang(p0, p1), 0.0), connection.right, NetworkCableRenderer.computeCableSwingAmount(p0, p1), connection.hashCode());
            VertexConsumer consumer = bufferSource.m_6299_(renderType);
            cablePoints.clear();
            cablePoints.ensureCapacity(9);
            for (i = 0; i < 9; ++i) {
                float t = (float)i / 8.0f;
                Vec3 p = NetworkCableRenderer.quadraticBezier(p0, p1, p2, t);
                Vec3 n = NetworkCableRenderer.getExtrusionVector(eye, p, connection.forward);
                BlockPos blockPos = new BlockPos(p);
                int blockLight = level.m_45517_(LightLayer.BLOCK, blockPos);
                int skyLight = level.m_45517_(LightLayer.SKY, blockPos);
                int packedLight = LightTexture.m_109885_((int)blockLight, (int)skyLight);
                Vector3f v0 = new Vector3f(p.m_82546_(n));
                Vector3f v1 = new Vector3f(p.m_82549_(n));
                cablePoints.add(new CablePoint(v0, v1, packedLight));
            }
            for (i = 0; i < cablePoints.size() - 1; ++i) {
                CablePoint pa = cablePoints.get(i);
                CablePoint pb = cablePoints.get(i + 1);
                consumer.m_85982_(viewMatrix, pa.v0.m_122239_(), pa.v0.m_122260_(), pa.v0.m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(pa.packedLight).m_5752_();
                consumer.m_85982_(viewMatrix, pa.v1.m_122239_(), pa.v1.m_122260_(), pa.v1.m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(pa.packedLight).m_5752_();
                consumer.m_85982_(viewMatrix, pb.v1.m_122239_(), pb.v1.m_122260_(), pb.v1.m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(pa.packedLight).m_5752_();
                consumer.m_85982_(viewMatrix, pb.v0.m_122239_(), pb.v0.m_122260_(), pb.v0.m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(pa.packedLight).m_5752_();
            }
            bufferSource.m_109912_(renderType);
        }
    }

    private static Vec3 lerp(Vec3 a, Vec3 b, float t) {
        return a.m_82549_(b.m_82546_(a).m_82490_((double)t));
    }

    private static Vec3 quadraticBezier(Vec3 a, Vec3 b, Vec3 c, float t) {
        Vec3 a1 = NetworkCableRenderer.lerp(a, c, t);
        Vec3 b1 = NetworkCableRenderer.lerp(c, b, t);
        return NetworkCableRenderer.lerp(a1, b1, t);
    }

    private static Vec3 getExtrusionVector(Vec3 eye, Vec3 v, Vec3 forward) {
        return forward.m_82537_(eye.m_82546_(v)).m_82541_().m_82490_((double)0.025f);
    }

    private static float computeCableHang(Vec3 a, Vec3 b) {
        double length = a.m_82554_(b);
        double hangFactor = Mth.m_14008_((double)(length / 8.0), (double)0.0, (double)1.0);
        return (float)((double)0.1f + (double)0.4f * hangFactor);
    }

    private static float computeCableSwingAmount(Vec3 p0, Vec3 p1) {
        return Mth.m_14036_((float)((float)p0.m_82554_(p1) / 6.0f), (float)0.1f, (float)1.0f) * 0.05f;
    }

    private static Vec3 animateCableSwing(Vec3 c, @Nullable Vec3 right, float swingAmount, int seed) {
        float relTime = (float)((System.currentTimeMillis() + (long)seed) % 8000L) / 8000.0f;
        float relRadialTime = relTime * 2.0f * (float)Math.PI;
        if (right == null) {
            return c.m_82520_((double)(swingAmount * Mth.m_14031_((float)relRadialTime)), 0.0, (double)(swingAmount * Mth.m_14089_((float)relRadialTime)));
        }
        return c.m_82520_((double)(swingAmount * Mth.m_14089_((float)relRadialTime)) * right.f_82479_, (double)(0.5f * swingAmount * Mth.m_14031_((float)(relRadialTime * 2.0f - (float)Math.PI)) - swingAmount), (double)(swingAmount * Mth.m_14089_((float)relRadialTime)) * right.f_82481_);
    }

    private static void validateConnectors() {
        ArrayList<NetworkConnectorBlockEntity> list = new ArrayList<NetworkConnectorBlockEntity>(connectors);
        for (NetworkConnectorBlockEntity connector : list) {
            if (!connector.m_58901_()) continue;
            connectors.remove(connector);
            connectionsByConnector.remove(connector);
            NetworkCableRenderer.invalidateConnections();
        }
        if (list.size() != lastKnownConnectorCount) {
            NetworkCableRenderer.invalidateConnections();
        }
        lastKnownConnectorCount = list.size();
    }

    private static void validatePairs() {
        if (!isDirty) {
            return;
        }
        isDirty = false;
        connections.clear();
        connectionsByConnector.clear();
        HashSet<Connection> seen = new HashSet<Connection>();
        for (NetworkConnectorBlockEntity connector : connectors) {
            BlockPos position = connector.m_58899_();
            for (BlockPos connectedPosition : connector.getConnectedPositions()) {
                Connection connection = new Connection(position, connectedPosition);
                if (!seen.add(connection)) continue;
                connections.add(connection);
                connectionsByConnector.computeIfAbsent(connector, unused -> new ArrayList()).add(connection);
            }
        }
    }

    static {
        connections = new ArrayList();
        connectionsByConnector = new WeakHashMap();
        cablePoints = new ArrayList();
    }

    private static final class Connection {
        private static final Vec3 POS_Y = new Vec3(0.0, 1.0, 0.0);
        public final BlockPos fromPos;
        public final BlockPos toPos;
        public final Vec3 from;
        public final Vec3 to;
        public final Vec3 forward;
        public final Vec3 right;
        public final AABB bounds;

        private Connection(BlockPos fromPos, BlockPos toPos) {
            if (fromPos.compareTo((Vec3i)toPos) > 0) {
                this.fromPos = toPos;
                this.toPos = fromPos;
            } else {
                this.fromPos = fromPos;
                this.toPos = toPos;
            }
            this.from = Vec3.m_82512_((Vec3i)fromPos);
            this.to = Vec3.m_82512_((Vec3i)toPos);
            this.forward = this.to.m_82546_(this.from).m_82541_();
            this.right = fromPos.m_123341_() == toPos.m_123341_() && fromPos.m_123343_() == toPos.m_123343_() ? null : this.forward.m_82537_(POS_Y);
            this.bounds = new AABB(this.from, this.to).m_82377_(0.0, 0.5, 0.0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Connection that = (Connection)o;
            return this.fromPos.equals((Object)that.fromPos) && this.toPos.equals((Object)that.toPos);
        }

        public int hashCode() {
            return Objects.hash(this.fromPos, this.toPos);
        }
    }

    private record CablePoint(Vector3f v0, Vector3f v1, int packedLight) {
    }
}

