/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.block.BusCableBlock;
import li.cil.oc2.common.blockentity.BusCableBlockEntity;
import li.cil.oc2.common.util.ItemStackUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public record BusCableBakedModel(BakedModel proxy, BakedModel[] straightModelByAxis, BakedModel[] supportModelByFace) implements IDynamicBakedModel
{
    private static final ModelProperty<BusCableSupportSide> BUS_CABLE_SUPPORT_PROPERTY = new ModelProperty();
    private static final ModelProperty<BusCableFacade> BUS_CABLE_FACADE_PROPERTY = new ModelProperty();

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        RenderType layer = MinecraftForgeClient.getRenderType();
        if (extraData.hasProperty(BUS_CABLE_FACADE_PROPERTY)) {
            BusCableFacade facade = (BusCableFacade)extraData.getData(BUS_CABLE_FACADE_PROPERTY);
            if (facade != null && (layer == null || ItemBlockRenderTypes.canRenderInLayer((BlockState)facade.blockState, (RenderType)layer))) {
                return facade.model.getQuads(facade.blockState, side, rand, facade.data);
            }
            return Collections.emptyList();
        }
        if (state == null || !((Boolean)state.m_61143_((Property)BusCableBlock.HAS_CABLE)).booleanValue() || layer == null || !layer.equals(RenderType.m_110451_())) {
            return Collections.emptyList();
        }
        for (int i = 0; i < Constants.AXES.length; ++i) {
            Direction.Axis axis = Constants.AXES[i];
            if (!BusCableBakedModel.isStraightAlongAxis(state, axis)) continue;
            return this.straightModelByAxis[i].getQuads(state, side, rand, extraData);
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.proxy.getQuads(state, side, rand, extraData));
        BusCableSupportSide supportSide = (BusCableSupportSide)extraData.getData(BUS_CABLE_SUPPORT_PROPERTY);
        if (supportSide != null) {
            quads.addAll(this.supportModelByFace[supportSide.value.m_122411_()].getQuads(state, side, rand, extraData));
        }
        return quads;
    }

    public boolean m_7541_() {
        return this.proxy.m_7541_();
    }

    public boolean m_7539_() {
        return this.proxy.m_7539_();
    }

    public boolean m_7547_() {
        return this.proxy.m_7547_();
    }

    public boolean m_7521_() {
        return this.proxy.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.proxy.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.proxy.m_7343_();
    }

    @Nonnull
    public IModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, IModelData blockEntityData) {
        if (state.m_61138_((Property)BusCableBlock.HAS_FACADE) && ((Boolean)state.m_61143_((Property)BusCableBlock.HAS_FACADE)).booleanValue()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            BlockState facadeState = null;
            if (blockEntity instanceof BusCableBlockEntity) {
                BusCableBlockEntity busCable = (BusCableBlockEntity)blockEntity;
                ItemStack facadeItem = busCable.getFacade();
                facadeState = ItemStackUtils.getBlockState(facadeItem);
            }
            if (facadeState == null) {
                facadeState = Blocks.f_50075_.m_49966_();
            }
            BlockModelShaper shapes = Minecraft.m_91087_().m_91289_().m_110907_();
            BakedModel model = shapes.m_110893_(facadeState);
            IModelData data = model.getModelData(level, pos, facadeState, blockEntityData);
            return new ModelDataMap.Builder().withInitial(BUS_CABLE_FACADE_PROPERTY, (Object)new BusCableFacade(facadeState, model, data)).build();
        }
        Direction supportSide = null;
        for (Direction direction : Constants.DIRECTIONS) {
            if (!BusCableBakedModel.isNeighborInDirectionSolid(level, pos, direction)) continue;
            EnumProperty<BusCableBlock.ConnectionType> property = BusCableBlock.FACING_TO_CONNECTION_MAP.get(direction);
            if (state.m_61138_(property) && state.m_61143_(property) == BusCableBlock.ConnectionType.INTERFACE) {
                return blockEntityData;
            }
            if (supportSide != null) continue;
            supportSide = direction;
        }
        if (supportSide != null) {
            return new ModelDataMap.Builder().withInitial(BUS_CABLE_SUPPORT_PROPERTY, (Object)new BusCableSupportSide(supportSide)).build();
        }
        return blockEntityData;
    }

    private static boolean isNeighborInDirectionSolid(BlockAndTintGetter level, BlockPos pos, Direction direction) {
        BlockPos neighborPos = pos.m_142300_(direction);
        return level.m_8055_(neighborPos).m_60783_((BlockGetter)level, neighborPos, direction.m_122424_());
    }

    private static boolean isStraightAlongAxis(BlockState state, Direction.Axis axis) {
        for (Direction direction : Constants.DIRECTIONS) {
            EnumProperty<BusCableBlock.ConnectionType> property = BusCableBlock.FACING_TO_CONNECTION_MAP.get(direction);
            if (!(axis.test(direction) ? state.m_61143_(property) != BusCableBlock.ConnectionType.CABLE : state.m_61143_(property) != BusCableBlock.ConnectionType.NONE)) continue;
            return false;
        }
        return true;
    }

    private record BusCableFacade(BlockState blockState, BakedModel model, IModelData data) {
    }

    private record BusCableSupportSide(Direction value) {
    }
}

