/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import li.cil.oc2.client.gui.widget.Sprite;
import li.cil.oc2.common.util.TextFormatUtils;
import li.cil.oc2.common.util.TooltipUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;

public abstract class ImageButton
extends AbstractButton {
    private static final long PRESS_DURATION = 200L;
    private static final long TOOLTIP_DELAY = 250L;
    private final Sprite baseImage;
    private final Sprite pressedImage;
    private List<Component> tooltip = Collections.emptyList();
    private long lastPressedAt;
    private long hoveringStartedAt;

    protected ImageButton(int x, int y, int width, int height, Sprite baseImage, Sprite pressedImage) {
        super(x, y, width, height, TextComponent.f_131282_);
        this.baseImage = baseImage;
        this.pressedImage = pressedImage;
    }

    public ImageButton withMessage(Component component) {
        this.m_93666_(component);
        return this;
    }

    public ImageButton withTooltip(Component ... components) {
        this.tooltip = Arrays.asList(components);
        for (int i = 1; i < this.tooltip.size(); ++i) {
            Component component = this.tooltip.get(i);
            this.tooltip.set(i, TextFormatUtils.withFormat(component, ChatFormatting.GRAY));
        }
        return this;
    }

    public void m_5691_() {
        this.lastPressedAt = System.currentTimeMillis();
    }

    public void m_6303_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(stack, mouseX, mouseY, partialTicks);
        this.m_7428_(stack, mouseX, mouseY);
    }

    public void m_7428_(PoseStack stack, int mouseX, int mouseY) {
        if (this.tooltip.isEmpty()) {
            return;
        }
        if (this.m_198029_()) {
            if (this.hoveringStartedAt == 0L) {
                this.hoveringStartedAt = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - this.hoveringStartedAt > 250L) {
                TooltipUtils.drawTooltip(stack, this.tooltip, mouseX, mouseY, 200);
            }
        } else {
            this.hoveringStartedAt = 0L;
        }
    }

    public void m_142291_(NarrationElementOutput element) {
        this.m_168802_(element);
    }

    protected void renderBackground(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_69482_();
        Sprite background = this.baseImage;
        if (System.currentTimeMillis() - this.lastPressedAt < 200L) {
            background = this.pressedImage;
        }
        background.draw(stack, this.f_93620_, this.f_93621_);
        if (!Objects.equals(this.m_6035_(), TextComponent.f_131282_)) {
            ImageButton.m_93215_((PoseStack)stack, (Font)Minecraft.m_91087_().f_91062_, (Component)this.m_6035_(), (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)(this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
        }
    }
}

