/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import li.cil.oc2.api.bus.device.DeviceType;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.client.gui.widget.Sprite;
import li.cil.oc2.common.container.DeviceTypeSlotItemHandler;
import li.cil.oc2.common.util.TooltipUtils;
import li.cil.oc2.common.util.TranslationUtils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public final class GuiUtils {
    private static final Map<DeviceType, Component> WARNING_BY_DEVICE_TYPE = (Map)Util.m_137537_(() -> {
        HashMap<DeviceType, TranslatableComponent> map = new HashMap<DeviceType, TranslatableComponent>();
        map.put(DeviceTypes.FLASH_MEMORY, TranslationUtils.text("tooltip.{mod}.flash_memory_missing"));
        map.put(DeviceTypes.MEMORY, TranslationUtils.text("tooltip.{mod}.memory_missing"));
        map.put(DeviceTypes.HARD_DRIVE, TranslationUtils.text("tooltip.{mod}.hard_drive_missing"));
        return map;
    });
    private static final int SLOT_SIZE = 18;
    private static final int DEVICE_INFO_ICON_SIZE = 28;
    private static final int RELATIVE_ICON_POSITION = -5;

    public static <TContainer extends AbstractContainerMenu> void renderMissingDeviceInfoIcon(PoseStack stack, AbstractContainerScreen<TContainer> screen, DeviceType type, Sprite icon) {
        stack.m_85836_();
        stack.m_85837_(0.0, 0.0, 100.0);
        GuiUtils.findFirstSlotOfTypeIfAllSlotsOfTypeEmpty(screen.m_6262_(), type).ifPresent(slot -> icon.draw(stack, screen.getGuiLeft() + slot.f_40220_ - 1 + -5, screen.getGuiTop() + slot.f_40221_ - 1 + -5));
        stack.m_85849_();
    }

    public static <TContainer extends AbstractContainerMenu> void renderMissingDeviceInfoTooltip(PoseStack stack, AbstractContainerScreen<TContainer> screen, int mouseX, int mouseY, DeviceType type) {
        GuiUtils.renderMissingDeviceInfoTooltip(stack, screen, mouseX, mouseY, type, Objects.requireNonNull(WARNING_BY_DEVICE_TYPE.get(type)));
    }

    public static <TContainer extends AbstractContainerMenu> void renderMissingDeviceInfoTooltip(PoseStack stack, AbstractContainerScreen<TContainer> screen, int mouseX, int mouseY, DeviceType type, Component tooltip) {
        boolean isCursorHoldingStack;
        Minecraft minecraft = screen.getMinecraft();
        if (minecraft.f_91074_ == null) {
            return;
        }
        boolean bl = isCursorHoldingStack = !minecraft.f_91074_.f_36095_.m_142621_().m_41619_();
        if (isCursorHoldingStack) {
            return;
        }
        Slot hoveredSlot = screen.getSlotUnderMouse();
        if (hoveredSlot != null && hoveredSlot.m_6657_()) {
            return;
        }
        GuiUtils.findFirstSlotOfTypeIfAllSlotsOfTypeEmpty(screen.m_6262_(), type).ifPresent(slot -> {
            if (slot == hoveredSlot) {
                TooltipUtils.drawTooltip(stack, Collections.singletonList(tooltip), mouseX, mouseY);
            }
        });
    }

    private static Optional<DeviceTypeSlotItemHandler> findFirstSlotOfTypeIfAllSlotsOfTypeEmpty(AbstractContainerMenu container, DeviceType type) {
        DeviceTypeSlotItemHandler firstSlot = null;
        for (Slot slot : container.f_38839_) {
            DeviceTypeSlotItemHandler typedSlot;
            DeviceType slotType;
            if (!(slot instanceof DeviceTypeSlotItemHandler) || (slotType = (typedSlot = (DeviceTypeSlotItemHandler)slot).getDeviceType()) != type) continue;
            if (slot.m_6657_()) {
                return Optional.empty();
            }
            if (firstSlot != null) continue;
            firstSlot = typedSlot;
        }
        return Optional.ofNullable(firstSlot);
    }
}

