/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.oc2.client.gui.AbstractMachineTerminalScreen;
import li.cil.oc2.client.gui.Sprites;
import li.cil.oc2.client.gui.terminal.TerminalInput;
import li.cil.oc2.common.container.AbstractMachineTerminalContainer;
import li.cil.oc2.common.vm.Terminal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class MachineTerminalWidget
extends GuiComponent {
    private static final int TERMINAL_WIDTH = 320;
    private static final int TERMINAL_HEIGHT = 192;
    private static final int MARGIN_SIZE = 8;
    private static final int TERMINAL_X = 8;
    private static final int TERMINAL_Y = 8;
    public static final int WIDTH = Sprites.TERMINAL_SCREEN.width;
    public static final int HEIGHT = Sprites.TERMINAL_SCREEN.height;
    private final AbstractMachineTerminalScreen<?> parent;
    private final AbstractMachineTerminalContainer container;
    private final Terminal terminal;
    private int leftPos;
    private int topPos;
    private boolean isMouseOverTerminal;
    private Terminal.RendererView rendererView;

    public MachineTerminalWidget(AbstractMachineTerminalScreen<?> parent) {
        this.parent = parent;
        this.container = (AbstractMachineTerminalContainer)this.parent.m_6262_();
        this.terminal = this.container.getTerminal();
    }

    public void renderBackground(PoseStack stack, int mouseX, int mouseY) {
        this.isMouseOverTerminal = this.isMouseOverTerminal(mouseX, mouseY);
        Sprites.TERMINAL_SCREEN.draw(stack, this.leftPos, this.topPos);
        if (this.shouldCaptureInput()) {
            Sprites.TERMINAL_FOCUSED.draw(stack, this.leftPos, this.topPos);
        }
    }

    public void render(PoseStack stack, int mouseX, int mouseY, @Nullable Component error) {
        if (this.container.getVirtualMachine().isRunning()) {
            PoseStack terminalStack = new PoseStack();
            terminalStack.m_85837_((double)(this.leftPos + 8), (double)(this.topPos + 8), (double)this.getClient().m_91291_().f_115093_);
            terminalStack.m_85841_(320.0f / (float)this.terminal.getWidth(), 192.0f / (float)this.terminal.getHeight(), 1.0f);
            if (this.rendererView == null) {
                this.rendererView = this.terminal.getRenderer();
            }
            Matrix4f projectionMatrix = Matrix4f.m_162203_((float)0.0f, (float)this.parent.f_96543_, (float)0.0f, (float)this.parent.f_96544_, (float)-10.0f, (float)10.0f);
            this.rendererView.render(terminalStack, projectionMatrix);
        } else {
            Font font = this.getClient().f_91062_;
            if (error != null) {
                int textWidth = font.m_92852_((FormattedText)error);
                int textOffsetX = (320 - textWidth) / 2;
                Objects.requireNonNull(font);
                int textOffsetY = (192 - 9) / 2;
                font.m_92763_(stack, error, (float)(this.leftPos + 8 + textOffsetX), (float)(this.topPos + 8 + textOffsetY), 0xEE3322);
            }
        }
    }

    public void tick() {
        ByteBuffer input = this.terminal.getInput();
        if (input != null) {
            this.container.sendTerminalInputToServer(input);
        }
    }

    public boolean charTyped(char ch, int modifier) {
        if (modifier == 0 || modifier == 1) {
            this.terminal.putInput((byte)ch);
        }
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        block4: {
            block3: {
                if (!this.shouldCaptureInput() && keyCode == 256) {
                    return false;
                }
                if ((modifiers & 2) == 0 || keyCode != 86) break block3;
                String value = this.getClient().f_91068_.m_90876_();
                for (char ch : value.toCharArray()) {
                    this.terminal.putInput((byte)ch);
                }
                break block4;
            }
            byte[] sequence = TerminalInput.getSequence(keyCode, modifiers);
            if (sequence == null) break block4;
            for (byte b : sequence) {
                this.terminal.putInput(b);
            }
        }
        return true;
    }

    public void init() {
        this.leftPos = (this.parent.f_96543_ - WIDTH) / 2;
        this.topPos = (this.parent.f_96544_ - HEIGHT) / 2;
        this.getClient().f_91068_.m_90926_(true);
    }

    public void onClose() {
        this.getClient().f_91068_.m_90926_(false);
        if (this.rendererView != null) {
            this.terminal.releaseRenderer(this.rendererView);
            this.rendererView = null;
        }
    }

    private Minecraft getClient() {
        return this.parent.getMinecraft();
    }

    private boolean shouldCaptureInput() {
        return this.isMouseOverTerminal && AbstractMachineTerminalScreen.isInputCaptureEnabled() && this.container.getVirtualMachine().isRunning();
    }

    private boolean isMouseOverTerminal(int mouseX, int mouseY) {
        return this.parent.isMouseOver(mouseX, mouseY, 8, 8, 320, 192);
    }
}

