/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import li.cil.oc2.client.gui.AbstractModContainerScreen;
import li.cil.oc2.client.gui.MachineTerminalWidget;
import li.cil.oc2.client.gui.Sprites;
import li.cil.oc2.client.gui.widget.ImageButton;
import li.cil.oc2.client.gui.widget.ToggleImageButton;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.container.AbstractMachineTerminalContainer;
import li.cil.oc2.common.util.TextFormatUtils;
import li.cil.oc2.common.util.TooltipUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractMachineTerminalScreen<T extends AbstractMachineTerminalContainer>
extends AbstractModContainerScreen<T> {
    private static final int CONTROLS_TOP = 8;
    private static final int ENERGY_TOP = 8 + Sprites.SIDEBAR_3.height + 4;
    private static boolean isInputCaptureEnabled;
    private final MachineTerminalWidget terminalWidget = new MachineTerminalWidget(this);

    protected AbstractMachineTerminalScreen(T container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.f_97726_ = Sprites.TERMINAL_SCREEN.width;
        this.f_97727_ = Sprites.TERMINAL_SCREEN.height;
    }

    public static boolean isInputCaptureEnabled() {
        return isInputCaptureEnabled;
    }

    public void m_181908_() {
        super.m_181908_();
        this.terminalWidget.tick();
    }

    public boolean m_5534_(char ch, int modifiers) {
        return this.terminalWidget.charTyped(ch, modifiers) || super.m_5534_(ch, modifiers);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.terminalWidget.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        InputConstants.Key input = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(input)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7856_() {
        super.m_7856_();
        this.terminalWidget.init();
        EditBox focusIndicatorEditBox = new EditBox(this.f_96547_, 0, 0, 0, 0, TextComponent.f_131282_);
        focusIndicatorEditBox.m_94178_(true);
        this.setFocusIndicatorEditBox(focusIndicatorEditBox);
        (this.m_142416_((GuiEventListener)new ToggleImageButton(this.f_97735_ - Sprites.SIDEBAR_3.width + 4, this.f_97736_ + 8 + 4, 12, 12, Sprites.POWER_BUTTON_BASE, Sprites.POWER_BUTTON_PRESSED, Sprites.POWER_BUTTON_ACTIVE){

            @Override
            public void m_5691_() {
                super.m_5691_();
                ((AbstractMachineTerminalContainer)AbstractMachineTerminalScreen.this.f_97732_).sendPowerStateToServer(!((AbstractMachineTerminalContainer)AbstractMachineTerminalScreen.this.f_97732_).getVirtualMachine().isRunning());
            }

            @Override
            public boolean isToggled() {
                return ((AbstractMachineTerminalContainer)AbstractMachineTerminalScreen.this.f_97732_).getVirtualMachine().isRunning();
            }
        })).withTooltip(new Component[]{new TranslatableComponent(Constants.COMPUTER_SCREEN_POWER_CAPTION), new TranslatableComponent(Constants.COMPUTER_SCREEN_POWER_DESCRIPTION)});
        (this.m_142416_((GuiEventListener)new ToggleImageButton(this.f_97735_ - Sprites.SIDEBAR_3.width + 4, this.f_97736_ + 8 + 4 + 14, 12, 12, Sprites.INPUT_BUTTON_BASE, Sprites.INPUT_BUTTON_PRESSED, Sprites.INPUT_BUTTON_ACTIVE){

            @Override
            public void m_5691_() {
                super.m_5691_();
                isInputCaptureEnabled = !isInputCaptureEnabled;
            }

            @Override
            public boolean isToggled() {
                return isInputCaptureEnabled;
            }
        })).withTooltip(new Component[]{new TranslatableComponent(Constants.TERMINAL_CAPTURE_INPUT_CAPTION), new TranslatableComponent(Constants.TERMINAL_CAPTURE_INPUT_DESCRIPTION)});
        (this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ - Sprites.SIDEBAR_3.width + 4, this.f_97736_ + 8 + 4 + 14 + 14, 12, 12, Sprites.INVENTORY_BUTTON_INACTIVE, Sprites.INVENTORY_BUTTON_ACTIVE){

            @Override
            public void m_5691_() {
                ((AbstractMachineTerminalContainer)AbstractMachineTerminalScreen.this.f_97732_).switchToInventory();
            }
        })).withTooltip(new Component[]{new TranslatableComponent(Constants.MACHINE_OPEN_INVENTORY_CAPTION)});
    }

    public void m_7379_() {
        super.m_7379_();
        this.terminalWidget.onClose();
    }

    protected abstract void setFocusIndicatorEditBox(EditBox var1);

    @Override
    protected void renderFg(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        super.renderFg(stack, partialTicks, mouseX, mouseY);
        if (this.shouldRenderEnergyBar()) {
            int x = this.f_97735_ - Sprites.SIDEBAR_2.width + 4;
            int y = this.f_97736_ + ENERGY_TOP + 4;
            Sprites.ENERGY_BAR.drawFillY(stack, x, y, (float)((AbstractMachineTerminalContainer)this.f_97732_).getEnergy() / (float)((AbstractMachineTerminalContainer)this.f_97732_).getEnergyCapacity());
        }
        this.terminalWidget.render(stack, mouseX, mouseY, ((AbstractMachineTerminalContainer)this.f_97732_).getVirtualMachine().getBootError());
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        Sprites.SIDEBAR_3.draw(stack, this.f_97735_ - Sprites.SIDEBAR_2.width, this.f_97736_ + 8);
        if (this.shouldRenderEnergyBar()) {
            int x = this.f_97735_ - Sprites.SIDEBAR_2.width;
            int y = this.f_97736_ + ENERGY_TOP;
            Sprites.SIDEBAR_2.draw(stack, x, y);
            Sprites.ENERGY_BASE.draw(stack, x + 4, y + 4);
        }
        this.terminalWidget.renderBackground(stack, mouseX, mouseY);
    }

    @Override
    protected void m_7025_(PoseStack stack, int mouseX, int mouseY) {
        super.m_7025_(stack, mouseX, mouseY);
        if (this.shouldRenderEnergyBar() && this.isMouseOver(mouseX, mouseY, -Sprites.SIDEBAR_2.width + 4, ENERGY_TOP + 4, Sprites.ENERGY_BAR.width, Sprites.ENERGY_BAR.height)) {
            List<TranslatableComponent> tooltip = Arrays.asList(new TranslatableComponent(Constants.TOOLTIP_ENERGY, new Object[]{TextFormatUtils.withFormat(((AbstractMachineTerminalContainer)this.f_97732_).getEnergy() + "/" + ((AbstractMachineTerminalContainer)this.f_97732_).getEnergyCapacity(), ChatFormatting.GREEN)}), new TranslatableComponent(Constants.TOOLTIP_ENERGY_CONSUMPTION, new Object[]{TextFormatUtils.withFormat(String.valueOf(((AbstractMachineTerminalContainer)this.f_97732_).getEnergyConsumption()), ChatFormatting.GREEN)}));
            TooltipUtils.drawTooltip(stack, tooltip, mouseX, mouseY, 200);
        }
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
    }

    private boolean shouldRenderEnergyBar() {
        return ((AbstractMachineTerminalContainer)this.f_97732_).getEnergyCapacity() > 0;
    }
}

