/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client;

import java.util.Objects;
import li.cil.oc2.api.bus.device.DeviceType;
import li.cil.oc2.client.gui.ComputerContainerScreen;
import li.cil.oc2.client.gui.ComputerTerminalScreen;
import li.cil.oc2.client.gui.NetworkTunnelScreen;
import li.cil.oc2.client.gui.RobotContainerScreen;
import li.cil.oc2.client.gui.RobotTerminalScreen;
import li.cil.oc2.client.item.CustomItemColors;
import li.cil.oc2.client.item.CustomItemModelProperties;
import li.cil.oc2.client.model.BusCableModelLoader;
import li.cil.oc2.client.renderer.BusInterfaceNameRenderer;
import li.cil.oc2.client.renderer.NetworkCableRenderer;
import li.cil.oc2.client.renderer.blockentity.ChargerRenderer;
import li.cil.oc2.client.renderer.blockentity.ComputerRenderer;
import li.cil.oc2.client.renderer.blockentity.DiskDriveRenderer;
import li.cil.oc2.client.renderer.blockentity.NetworkConnectorRenderer;
import li.cil.oc2.client.renderer.color.BusCableBlockColor;
import li.cil.oc2.client.renderer.entity.RobotRenderer;
import li.cil.oc2.client.renderer.entity.model.RobotModel;
import li.cil.oc2.common.block.Blocks;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.bus.device.DeviceTypes;
import li.cil.oc2.common.container.Containers;
import li.cil.oc2.common.entity.Entities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public final class ClientSetup {
    @SubscribeEvent
    public static void handleSetupEvent(FMLClientSetupEvent event) {
        NetworkCableRenderer.initialize();
        BusInterfaceNameRenderer.initialize();
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntities.COMPUTER.get()), ComputerRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntities.NETWORK_CONNECTOR.get()), NetworkConnectorRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntities.DISK_DRIVE.get()), DiskDriveRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntities.CHARGER.get()), ChargerRenderer::new);
        event.enqueueWork(() -> {
            CustomItemModelProperties.initialize();
            CustomItemColors.initialize();
            MenuScreens.m_96206_((MenuType)((MenuType)Containers.COMPUTER.get()), ComputerContainerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Containers.COMPUTER_TERMINAL.get()), ComputerTerminalScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Containers.ROBOT.get()), RobotContainerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Containers.ROBOT_TERMINAL.get()), RobotTerminalScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Containers.NETWORK_TUNNEL.get()), NetworkTunnelScreen::new);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.BUS_CABLE.get()), renderType -> true);
            Minecraft.m_91087_().m_91298_().m_92589_((BlockColor)new BusCableBlockColor(), new Block[]{(Block)Blocks.BUS_CABLE.get()});
        });
    }

    @SubscribeEvent
    public static void handleModelRegistryEvent(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)Blocks.BUS_CABLE.getId(), (IModelLoader)new BusCableModelLoader());
    }

    @SubscribeEvent
    public static void handleTextureStitchEvent(TextureStitchEvent.Pre event) {
        if (!Objects.equals(event.getAtlas().m_118330_(), InventoryMenu.f_39692_)) {
            return;
        }
        for (DeviceType deviceType : DeviceTypes.DEVICE_TYPE_REGISTRY.get().getValues()) {
            event.addSprite(deviceType.getBackgroundIcon());
        }
        event.addSprite(ComputerRenderer.OVERLAY_POWER_LOCATION);
        event.addSprite(ComputerRenderer.OVERLAY_STATUS_LOCATION);
        event.addSprite(ComputerRenderer.OVERLAY_TERMINAL_LOCATION);
        event.addSprite(ChargerRenderer.EFFECT_LOCATION);
    }

    @SubscribeEvent
    public static void handleEntityRendererRegisterEvent(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)Entities.ROBOT.get(), RobotRenderer::new);
    }

    @SubscribeEvent
    public static void handleRegisterLayerDefinitionsEvent(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(RobotModel.ROBOT_MODEL_LAYER, RobotModel::createRobotLayer);
    }
}

