/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public final class Invalidatable<T> {
    private static final Invalidatable EMPTY = new Invalidatable();
    private final List<Consumer<Invalidatable<T>>> listeners = new ArrayList<Consumer<Invalidatable<T>>>();
    private T value;
    private boolean isValid = true;

    public static <T> Invalidatable<T> empty() {
        return EMPTY;
    }

    public static <T> Invalidatable<T> of(T value) {
        return new Invalidatable<T>(value);
    }

    public Invalidatable(T value) {
        this.value = value;
    }

    private Invalidatable() {
        this.value = null;
        this.isValid = false;
    }

    public T get() {
        if (this.isValid) {
            assert (this.value != null);
            return this.value;
        }
        throw new IllegalStateException();
    }

    public boolean isPresent() {
        return this.isValid;
    }

    public void ifPresent(Consumer<T> consumer) {
        if (this.isValid) {
            consumer.accept(this.value);
        }
    }

    public <U> Invalidatable<U> mapWithDependency(Function<T, U> mapper) {
        if (!this.isValid) {
            return Invalidatable.empty();
        }
        Invalidatable mapped = new Invalidatable(mapper.apply(this.value));
        ListenerToken token = this.addListener(unused -> mapped.invalidate());
        mapped.addListener(unused -> token.removeListener());
        return mapped;
    }

    public void invalidate() {
        if (this.isValid) {
            this.isValid = false;
            this.value = null;
            this.listeners.forEach(listener -> listener.accept(this));
            this.listeners.clear();
        }
    }

    public ListenerToken addListener(Consumer<Invalidatable<T>> listener) {
        if (this.isValid) {
            this.listeners.add(listener);
            return () -> {
                if (this.isValid) {
                    this.listeners.remove(listener);
                }
            };
        }
        listener.accept(this);
        return () -> {};
    }

    @FunctionalInterface
    public static interface ListenerToken {
        public void removeListener();
    }
}

