/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.vanilla;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.api.instance.TickableInstance;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.hardcoded.ModelPart;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.core.model.Model;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MinecartInstance<T extends AbstractMinecart>
extends EntityInstance<T>
implements DynamicInstance,
TickableInstance {
    private static final ResourceLocation MINECART_LOCATION = new ResourceLocation("textures/entity/minecart.png");
    MatrixTransformStack stack = new MatrixTransformStack();
    private final ModelData body;
    private ModelData contents;
    private BlockState blockstate;

    public MinecartInstance(MaterialManager materialManager, T entity) {
        super(materialManager, entity);
        this.blockstate = entity.m_38178_();
        this.contents = this.getContents();
        this.body = this.getBody();
    }

    @Override
    public void tick() {
        BlockState displayBlockState = ((AbstractMinecart)this.entity).m_38178_();
        if (displayBlockState != this.blockstate) {
            this.blockstate = displayBlockState;
            this.contents.delete();
            this.contents = this.getContents();
            this.updateLight();
        }
    }

    @Override
    public void beginFrame() {
        this.stack.setIdentity();
        float pt = AnimationTickHolder.getPartialTicks();
        Vec3i originCoordinate = this.materialManager.getOriginCoordinate();
        this.stack.translate(Mth.m_14139_((double)pt, (double)((AbstractMinecart)this.entity).f_19790_, (double)((AbstractMinecart)this.entity).m_20185_()) - (double)originCoordinate.m_123341_(), Mth.m_14139_((double)pt, (double)((AbstractMinecart)this.entity).f_19791_, (double)((AbstractMinecart)this.entity).m_20186_()) - (double)originCoordinate.m_123342_(), Mth.m_14139_((double)pt, (double)((AbstractMinecart)this.entity).f_19792_, (double)((AbstractMinecart)this.entity).m_20189_()) - (double)originCoordinate.m_123343_());
        float yaw = Mth.m_14179_((float)pt, (float)((AbstractMinecart)this.entity).f_19859_, (float)((AbstractMinecart)this.entity).m_146908_());
        long i = (long)((AbstractMinecart)this.entity).m_142049_() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        this.stack.translate(f, f1, f2);
        this.stack.nudge(((AbstractMinecart)this.entity).m_142049_());
        double d0 = Mth.m_14139_((double)pt, (double)((AbstractMinecart)this.entity).f_19790_, (double)((AbstractMinecart)this.entity).m_20185_());
        double d1 = Mth.m_14139_((double)pt, (double)((AbstractMinecart)this.entity).f_19791_, (double)((AbstractMinecart)this.entity).m_20186_());
        double d2 = Mth.m_14139_((double)pt, (double)((AbstractMinecart)this.entity).f_19792_, (double)((AbstractMinecart)this.entity).m_20189_());
        Vec3 vector3d = ((AbstractMinecart)this.entity).m_38179_(d0, d1, d2);
        float f3 = Mth.m_14179_((float)pt, (float)((AbstractMinecart)this.entity).f_19860_, (float)((AbstractMinecart)this.entity).m_146909_());
        if (vector3d != null) {
            Vec3 vector3d1 = ((AbstractMinecart)this.entity).m_38096_(d0, d1, d2, (double)0.3f);
            Vec3 vector3d2 = ((AbstractMinecart)this.entity).m_38096_(d0, d1, d2, (double)-0.3f);
            if (vector3d1 == null) {
                vector3d1 = vector3d;
            }
            if (vector3d2 == null) {
                vector3d2 = vector3d;
            }
            this.stack.translate(vector3d.f_82479_ - d0, (vector3d1.f_82480_ + vector3d2.f_82480_) / 2.0 - d1, vector3d.f_82481_ - d2);
            Vec3 vector3d3 = vector3d2.m_82520_(-vector3d1.f_82479_, -vector3d1.f_82480_, -vector3d1.f_82481_);
            if (vector3d3.m_82553_() != 0.0) {
                vector3d3 = vector3d3.m_82541_();
                yaw = (float)(Math.atan2(vector3d3.f_82481_, vector3d3.f_82479_) * 180.0 / Math.PI);
                f3 = (float)(Math.atan(vector3d3.f_82480_) * 73.0);
            }
        }
        this.stack.translate(0.0, 0.375, 0.0);
        this.stack.multiply(Vector3f.f_122225_.m_122240_(180.0f - yaw));
        this.stack.multiply(Vector3f.f_122227_.m_122240_(-f3));
        float f5 = (float)((AbstractMinecart)this.entity).m_38176_() - pt;
        float f6 = ((AbstractMinecart)this.entity).m_38169_() - pt;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            this.stack.multiply(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f5) * f5 * f6 / 10.0f * (float)((AbstractMinecart)this.entity).m_38177_()));
        }
        int j = ((AbstractMinecart)this.entity).m_38183_();
        if (this.contents != null) {
            this.stack.pushPose();
            this.stack.scale(0.75f);
            this.stack.translate(-0.5, (float)(j - 8) / 16.0f, 0.5);
            this.stack.multiply(Vector3f.f_122225_.m_122240_(90.0f));
            this.contents.setTransform(this.stack.unwrap());
            this.stack.popPose();
        }
        this.body.setTransform(this.stack.unwrap());
    }

    @Override
    public void updateLight() {
        if (this.contents == null) {
            this.relight(this.getWorldPosition(), this.body);
        } else {
            this.relight(this.getWorldPosition(), this.body, this.contents);
        }
    }

    @Override
    public void remove() {
        this.body.delete();
        if (this.contents != null) {
            this.contents.delete();
        }
    }

    private ModelData getContents() {
        if (this.blockstate.m_60799_() == RenderShape.INVISIBLE) {
            return null;
        }
        return this.materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(this.blockstate).createInstance();
    }

    private ModelData getBody() {
        return this.materialManager.solid(RenderType.m_110446_((ResourceLocation)MINECART_LOCATION)).material(Materials.TRANSFORMED).model(((AbstractMinecart)this.entity).m_6095_(), this::getBodyModel).createInstance();
    }

    private Model getBodyModel() {
        int y = -3;
        return ModelPart.builder("minecart", 64, 32).cuboid().invertYZ().start(-10.0f, -8.0f, -y).size(20.0f, 16.0f, 2.0f).textureOffset(0, 10).rotateZ((float)Math.PI).rotateX(1.5707964f).endCuboid().cuboid().invertYZ().start(-8.0f, y, -10.0f).size(16.0f, 8.0f, 2.0f).rotateY(4.712389f).endCuboid().cuboid().invertYZ().start(-8.0f, y, -10.0f).size(16.0f, 8.0f, 2.0f).rotateY(1.5707964f).endCuboid().cuboid().invertYZ().start(-8.0f, y, -8.0f).size(16.0f, 8.0f, 2.0f).rotateY((float)Math.PI).endCuboid().cuboid().invertYZ().start(-8.0f, y, -8.0f).size(16.0f, 8.0f, 2.0f).endCuboid().build();
    }
}

