/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.lwjgl.system.MemoryUtil;

public class StringUtil {
    public static String args(String functionName, Object ... args) {
        return functionName + "(" + Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", ")) + ")";
    }

    public static String trimEnd(String value) {
        int len;
        int st = 0;
        for (len = value.length(); st < len && Character.isWhitespace(value.charAt(len - 1)); --len) {
        }
        return value.substring(0, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readToString(InputStream is) {
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = StringUtil.readToBuffer(is);
            int i = bytebuffer.position();
            ((Buffer)bytebuffer).rewind();
            String string = MemoryUtil.memASCII((ByteBuffer)bytebuffer, (int)i);
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (bytebuffer != null) {
                MemoryUtil.memFree((Buffer)bytebuffer);
            }
        }
        return null;
    }

    public static ByteBuffer readToBuffer(InputStream is) throws IOException {
        if (is instanceof FileInputStream) {
            FileInputStream fileinputstream = (FileInputStream)is;
            return StringUtil.readFileInputStream(fileinputstream);
        }
        return StringUtil.readInputStream(is);
    }

    private static ByteBuffer readInputStream(InputStream is) throws IOException {
        ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)8192);
        ReadableByteChannel readablebytechannel = Channels.newChannel(is);
        while (readablebytechannel.read(bytebuffer) != -1) {
            if (bytebuffer.remaining() != 0) continue;
            bytebuffer = MemoryUtil.memRealloc((ByteBuffer)bytebuffer, (int)(bytebuffer.capacity() * 2));
        }
        return bytebuffer;
    }

    private static ByteBuffer readFileInputStream(FileInputStream fileinputstream) throws IOException {
        FileChannel filechannel = fileinputstream.getChannel();
        ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)((int)filechannel.size() + 1));
        while (filechannel.read(bytebuffer) != -1) {
        }
        return bytebuffer;
    }
}

