/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.event;

import com.jozufozu.flywheel.backend.RenderLayer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.eventbus.api.Event;

public class RenderLayerEvent
extends Event {
    private final ClientLevel world;
    public final RenderType type;
    public final PoseStack stack;
    public final Matrix4f viewProjection;
    public final RenderBuffers buffers;
    public final double camX;
    public final double camY;
    public final double camZ;
    public final RenderLayer layer;

    public RenderLayerEvent(ClientLevel world, RenderType type, PoseStack stack, RenderBuffers buffers, double camX, double camY, double camZ) {
        this.world = world;
        this.type = type;
        this.stack = stack;
        this.viewProjection = stack.m_85850_().m_85861_().m_27658_();
        this.viewProjection.multiplyBackward(RenderSystem.m_157192_());
        this.buffers = buffers;
        this.camX = camX;
        this.camY = camY;
        this.camZ = camZ;
        this.layer = RenderLayer.getPrimaryLayer(type);
    }

    @Nullable
    public RenderLayer getLayer() {
        return this.layer;
    }

    public ClientLevel getWorld() {
        return this.world;
    }

    public RenderType getType() {
        return this.type;
    }

    public Matrix4f getViewProjection() {
        return this.viewProjection;
    }

    public double getCamX() {
        return this.camX;
    }

    public double getCamY() {
        return this.camY;
    }

    public double getCamZ() {
        return this.camZ;
    }

    public String toString() {
        return "RenderLayerEvent[" + this.layer + "][world=" + this.world + ", type=" + this.type + ", stack=" + this.stack + ", viewProjection=" + this.viewProjection + ", buffers=" + this.buffers + ", camX=" + this.camX + ", camY=" + this.camY + ", camZ=" + this.camZ + "]";
    }
}

