/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.compile;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.core.compile.CompileUtil;
import com.jozufozu.flywheel.core.compile.VertexData;
import com.jozufozu.flywheel.core.source.FileIndex;
import com.jozufozu.flywheel.core.source.ShaderLoadingException;
import com.jozufozu.flywheel.core.source.SourceFile;
import com.jozufozu.flywheel.core.source.error.ErrorReporter;
import com.jozufozu.flywheel.core.source.parse.ShaderFunction;
import com.jozufozu.flywheel.core.source.parse.ShaderStruct;
import com.jozufozu.flywheel.core.source.parse.StructField;
import com.jozufozu.flywheel.core.source.parse.Variable;
import com.jozufozu.flywheel.core.source.span.Span;
import java.util.Optional;

public class InstancingTemplateData
implements VertexData {
    public final SourceFile file;
    public final ShaderFunction vertexMain;
    public final Span vertexName;
    public final Span instanceName;
    public final ShaderStruct instance;

    public InstancingTemplateData(SourceFile file) {
        this.file = file;
        Optional<ShaderFunction> vertexFunc = file.findFunction("vertex");
        if (vertexFunc.isEmpty()) {
            ErrorReporter.generateFileError(file, "could not find \"vertex\" function");
            throw new ShaderLoadingException();
        }
        this.vertexMain = vertexFunc.get();
        ImmutableList<Variable> vertexParams = this.vertexMain.getParameters();
        if (vertexParams.size() != 2) {
            ErrorReporter.generateSpanError(this.vertexMain.getArgs(), "instancing requires vertex function to have 2 arguments");
            throw new ShaderLoadingException();
        }
        Variable vertexParam = (Variable)vertexParams.get(0);
        this.vertexName = vertexParam.type;
        boolean namedVertex = vertexParam.type.toString().equals("Vertex");
        if (!namedVertex || vertexParam.qualifier != Variable.Qualifier.INOUT) {
            ErrorReporter.generateSpanError(vertexParam.qualifierSpan, "first parameter must be inout Vertex");
            throw new ShaderLoadingException();
        }
        this.instanceName = ((Variable)vertexParams.get((int)1)).type;
        Optional<ShaderStruct> maybeInstance = file.findStruct(this.instanceName);
        if (maybeInstance.isEmpty()) {
            ErrorReporter.generateMissingStruct(file, this.instanceName, "struct not defined");
            throw new ShaderLoadingException();
        }
        this.instance = maybeInstance.get();
    }

    @Override
    public String generateFooter(FileIndex shader, VertexType vertexType) {
        ImmutableList<StructField> fields = this.instance.getFields();
        int attributeBinding = vertexType.getLayout().getAttributeCount();
        StringBuilder template = new StringBuilder();
        for (StructField field : fields) {
            template.append("layout(location = ").append(attributeBinding).append(") in").append(' ').append(field.type).append(' ').append("a_i_").append(field.name).append(";\n");
            attributeBinding += CompileUtil.getAttributeCount(field.type);
        }
        template.append(String.format("out vec4 v2f_color;\nout vec2 v2f_texCoords;\nout vec2 v2f_light;\nout float v2f_diffuse;\n\nvoid main() {\n    Vertex v = FLWCreateVertex();\n    %s i;\n    %s\n    vertex(v, i);\n    gl_Position = FLWVertex(v);\n    v.normal = normalize(v.normal);\n\n    v2f_color = v.color;\n    v2f_texCoords = v.texCoords;\n    v2f_light = v.light;\n    v2f_diffuse = diffuse(v.normal);\n    #if defined(DEBUG_NORMAL)\n    v2f_color = vec4(v.normal, 1.);\n    #endif\n}\n", this.instanceName, InstancingTemplateData.assignFields(this.instance, "i.", "a_i_")));
        return template.toString();
    }

    public static StringBuilder assignFields(ShaderStruct struct, String prefix1, String prefix2) {
        ImmutableList<StructField> fields = struct.getFields();
        StringBuilder builder = new StringBuilder();
        for (StructField field : fields) {
            builder.append(prefix1).append(field.name).append(" = ").append(prefix2).append(field.name).append(";\n");
        }
        return builder;
    }
}

