/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.model;

import com.jozufozu.flywheel.util.RenderMath;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;

public class DirectVertexConsumer
implements VertexConsumer {
    public final VertexFormat format;
    private final int stride;
    public final int startPos;
    private int position = -1;
    private int normal = -1;
    private int color = -1;
    private int uv = -1;
    private int uv1 = -1;
    private int uv2 = -1;
    private long vertexBase;
    private final long end;

    public DirectVertexConsumer(ByteBuffer buffer, VertexFormat format, int maxVertices) {
        this.format = format;
        this.startPos = buffer.position();
        this.stride = format.m_86020_();
        int offset = 0;
        for (VertexFormatElement element : format.m_86023_()) {
            block0 : switch (element.m_86048_()) {
                case POSITION: {
                    this.position = offset;
                    break;
                }
                case NORMAL: {
                    this.normal = offset;
                    break;
                }
                case COLOR: {
                    this.color = offset;
                    break;
                }
                case UV: {
                    switch (element.m_86049_()) {
                        case 0: {
                            this.uv = offset;
                            break block0;
                        }
                        case 1: {
                            this.uv1 = offset;
                            break block0;
                        }
                        case 2: {
                            this.uv2 = offset;
                        }
                    }
                }
            }
            offset += element.m_86050_();
        }
        this.vertexBase = MemoryUtil.memAddress((ByteBuffer)buffer, (int)this.startPos);
        this.end = this.vertexBase + (long)maxVertices * (long)this.stride;
    }

    private DirectVertexConsumer(DirectVertexConsumer parent, int maxVertices) {
        this.format = parent.format;
        this.stride = parent.stride;
        this.startPos = parent.startPos;
        this.position = parent.position;
        this.normal = parent.normal;
        this.color = parent.color;
        this.uv = parent.uv;
        this.uv1 = parent.uv1;
        this.uv2 = parent.uv2;
        this.vertexBase = parent.vertexBase;
        this.end = parent.vertexBase + (long)maxVertices * (long)this.stride;
    }

    public void memSetZero() {
        MemoryUtil.memSet((long)this.vertexBase, (int)0, (long)(this.end - this.vertexBase));
    }

    public boolean hasOverlay() {
        return this.uv1 >= 0;
    }

    public DirectVertexConsumer split(int vertexCount) {
        int bytes = vertexCount * this.stride;
        DirectVertexConsumer head = new DirectVertexConsumer(this, vertexCount);
        this.vertexBase += (long)bytes;
        return head;
    }

    public VertexConsumer m_5483_(double x, double y, double z) {
        this.checkOverflow();
        if (this.position < 0) {
            return this;
        }
        long base = this.vertexBase + (long)this.position;
        MemoryUtil.memPutFloat((long)base, (float)((float)x));
        MemoryUtil.memPutFloat((long)(base + 4L), (float)((float)y));
        MemoryUtil.memPutFloat((long)(base + 8L), (float)((float)z));
        return this;
    }

    public VertexConsumer m_6122_(int r, int g, int b, int a) {
        if (this.color < 0) {
            return this;
        }
        long base = this.vertexBase + (long)this.color;
        MemoryUtil.memPutByte((long)base, (byte)((byte)r));
        MemoryUtil.memPutByte((long)(base + 1L), (byte)((byte)g));
        MemoryUtil.memPutByte((long)(base + 2L), (byte)((byte)b));
        MemoryUtil.memPutByte((long)(base + 3L), (byte)((byte)a));
        return this;
    }

    public VertexConsumer m_7421_(float u, float v) {
        if (this.uv < 0) {
            return this;
        }
        long base = this.vertexBase + (long)this.uv;
        MemoryUtil.memPutFloat((long)base, (float)u);
        MemoryUtil.memPutFloat((long)(base + 4L), (float)v);
        return this;
    }

    public VertexConsumer m_7122_(int u, int v) {
        if (this.uv1 < 0) {
            return this;
        }
        long base = this.vertexBase + (long)this.uv1;
        MemoryUtil.memPutShort((long)base, (short)((short)u));
        MemoryUtil.memPutShort((long)(base + 2L), (short)((short)v));
        return this;
    }

    public VertexConsumer m_7120_(int u, int v) {
        if (this.uv2 < 0) {
            return this;
        }
        long base = this.vertexBase + (long)this.uv2;
        MemoryUtil.memPutShort((long)base, (short)((short)u));
        MemoryUtil.memPutShort((long)(base + 2L), (short)((short)v));
        return this;
    }

    public VertexConsumer m_5601_(float x, float y, float z) {
        if (this.normal < 0) {
            return this;
        }
        long base = this.vertexBase + (long)this.normal;
        MemoryUtil.memPutByte((long)base, (byte)RenderMath.nb(x));
        MemoryUtil.memPutByte((long)(base + 1L), (byte)RenderMath.nb(y));
        MemoryUtil.memPutByte((long)(base + 2L), (byte)RenderMath.nb(z));
        return this;
    }

    public void m_5752_() {
        this.vertexBase += (long)this.stride;
    }

    public void m_142461_(int r, int g, int b, int a) {
    }

    public void m_141991_() {
    }

    private void checkOverflow() {
        if (this.vertexBase >= this.end) {
            throw new BufferOverflowException();
        }
    }
}

