/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.chisel.legacy.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.matthewperiut.chisel.Chisel;
import com.matthewperiut.chisel.legacy.config.BlockType;
import com.matthewperiut.chisel.legacy.data.Recipes;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;

public class BlockPack {
    private final String packDir;
    private File blockPackFolder;

    public BlockPack(String packDir) {
        this.packDir = packDir;
        this.blockPackFolder = new File(FabricLoader.getInstance().getConfigDir().toFile(), "chisel/" + packDir);
        if (!this.blockPackFolder.exists()) {
            File blockPackZip = new File(FabricLoader.getInstance().getConfigDir().toFile(), "chisel/" + packDir + ".zip");
            if (blockPackZip.exists()) {
                String msg = String.format("Blockpack %s needs to be removed from zip file. The blockpack will not load!", packDir);
                Chisel.LOGGER.warn(msg);
            } else {
                String msg = String.format("Blockpack folder not found for blockpack %s. The blockpack will not load!", packDir);
                Chisel.LOGGER.warn(msg);
            }
        }
    }

    public void register(RuntimeResourcePack resourcePack) {
        List<BlockType> types = this.getTypes();
        for (int i = 0; i < types.size(); ++i) {
            types.get(i).register(resourcePack);
        }
        this.registerTextures(resourcePack);
        this.registerLang(resourcePack);
        this.registerRecipes(resourcePack);
        this.registerWorldGen();
    }

    public void registerTextures(RuntimeResourcePack resourcePack) {
        File textureFolder = new File(this.blockPackFolder, "textures");
        if (!textureFolder.exists()) {
            String msg = String.format("No textures folder found for blockpack %s.", this.packDir);
            Chisel.LOGGER.info(msg);
            return;
        }
        List<File> textureFiles = this.getFilesFromDir(textureFolder);
        for (int i = 0; i < textureFiles.size(); ++i) {
            File textureFile = textureFiles.get(i);
            String region = textureFile.getAbsolutePath().substring(textureFolder.getAbsolutePath().length()).replace('\\', '/');
            resourcePack.addAsset(new class_2960("chisel", "textures/blocks/" + this.packDir + region), this.readFile(textureFile));
        }
    }

    public void registerLang(RuntimeResourcePack resourcePack) {
        File langFolder = new File(this.blockPackFolder, "lang");
        if (!langFolder.exists()) {
            String msg = String.format("No lang folder found for blockpack %s.", this.packDir);
            Chisel.LOGGER.info(msg);
            return;
        }
        List<File> langFiles = this.getFilesFromDir(langFolder);
        for (int i = 0; i < langFiles.size(); ++i) {
            File langFile = langFiles.get(i);
            String region = langFile.getName();
            resourcePack.addAsset(new class_2960("chisel", "lang/" + region), this.readFile(langFile));
        }
    }

    public void registerWorldGen() {
    }

    public void registerRecipes(RuntimeResourcePack resourcePack) {
        File recipes = new File(this.blockPackFolder, "recipes.json");
        if (!recipes.exists()) {
            return;
        }
        JsonObject recipesJson = this.getJsonFromFile(recipes);
        JsonElement recipesElement = recipesJson.get("recipes");
        if (recipesElement == null || !recipesElement.isJsonArray()) {
            return;
        }
        JsonArray recipesArray = recipesElement.getAsJsonArray();
        for (int i = 0; i < recipesArray.size(); ++i) {
            JsonObject recipeJson = recipesArray.get(i).getAsJsonObject();
            JsonObject keysJson = recipeJson.get("keys").getAsJsonObject();
            JsonArray patternJson = recipeJson.get("pattern").getAsJsonArray();
            JsonObject resultJson = recipeJson.get("result").getAsJsonObject();
            ArrayList<Recipes.RecipeKey> keys = new ArrayList<Recipes.RecipeKey>();
            for (Map.Entry keyJson : keysJson.entrySet()) {
                keys.add(new Recipes.RecipeKey((String)keyJson.getKey(), ((JsonElement)keyJson.getValue()).getAsString()));
            }
            ArrayList<String> pattern = new ArrayList<String>();
            for (int j = 0; j < patternJson.size(); ++j) {
                pattern.add(patternJson.get(j).getAsString());
            }
            String output = resultJson.get("item").getAsString();
            int amount = resultJson.get("amount").getAsInt();
            Recipes.addRecipe(pattern, keys, output, amount, resourcePack);
        }
    }

    public byte[] readFile(File lang) {
        byte[] byArray;
        FileInputStream stream = new FileInputStream(lang);
        try {
            byte[] bytes = new byte[stream.available()];
            int i = 0;
            while (i != -1) {
                i = stream.read(bytes);
            }
            byArray = bytes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new byte[0];
            }
        }
        stream.close();
        return byArray;
    }

    public List<BlockType> getTypes() {
        File typesFolder = new File(this.blockPackFolder, "types");
        if (!this.blockPackFolder.exists()) {
            String msg = String.format("No types folder found for blockpack %s.", this.packDir);
            Chisel.LOGGER.info(msg);
            return new ArrayList<BlockType>();
        }
        List<File> typeFiles = this.getFilesFromDir(typesFolder);
        ArrayList<BlockType> types = new ArrayList<BlockType>();
        for (int i = 0; i < typeFiles.size(); ++i) {
            File typeFile = typeFiles.get(i);
            JsonObject json = this.getJsonFromFile(typeFile);
            types.add(new BlockType(this.packDir, json));
        }
        return types;
    }

    public List<File> getFilesFromDir(File dir) {
        if (!dir.exists()) {
            return new ArrayList<File>();
        }
        ArrayList<File> dirFiles = new ArrayList<File>();
        File[] dirFilesArr = dir.listFiles();
        for (int i = 0; i < dirFilesArr.length; ++i) {
            File dirFile = dirFilesArr[i];
            if (dirFile.isDirectory()) {
                dirFiles.addAll(this.getFilesFromDir(dirFile));
                continue;
            }
            dirFiles.add(dirFile);
        }
        return dirFiles;
    }

    public JsonObject getJsonFromFile(File blockTypeFile) {
        JsonObject jsonObject;
        FileInputStream stream = new FileInputStream(blockTypeFile);
        try {
            byte[] bytes = new byte[stream.available()];
            int i = 0;
            while (i != -1) {
                i = stream.read(bytes);
            }
            String blockTypeString = new String(bytes);
            jsonObject = new JsonParser().parse(blockTypeString).getAsJsonObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        stream.close();
        return jsonObject;
    }
}

