/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.runtime;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.registry.Reloadable;
import me.shedaniel.rei.impl.client.gui.hints.HintProvider;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.jetbrains.annotations.Nullable;

public class PluginStageExecutionWatcher
implements HintProvider {
    private final Map<PluginManager<?>, Set<ReloadStage>> allStages = new HashMap();

    public <T extends REIPlugin<?>> Reloadable<? extends T> reloadable(final PluginManager<?> manager) {
        return new Reloadable<T>(){

            @Override
            public void startReload() {
                for (ReloadStage stage : ReloadStage.values()) {
                    this.startReload(stage);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startReload(ReloadStage stage) {
                Map<PluginManager<?>, Set<ReloadStage>> map = PluginStageExecutionWatcher.this.allStages;
                synchronized (map) {
                    Set stages = PluginStageExecutionWatcher.this.allStages.computeIfAbsent(manager, $ -> new HashSet());
                    if (stage.ordinal() == 0) {
                        stages.clear();
                    }
                    stages.add(stage);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ReloadStage> notVisited() {
        Map<PluginManager<?>, Set<ReloadStage>> map = this.allStages;
        synchronized (map) {
            HashSet<ReloadStage> notVisited = new HashSet<ReloadStage>(Arrays.asList(ReloadStage.values()));
            notVisited.removeIf(stage -> this.allStages.values().stream().allMatch(stages -> stages.contains(stage)));
            return notVisited;
        }
    }

    @Override
    public List<class_2561> provide() {
        Set<ReloadStage> notVisited = this.notVisited();
        if (notVisited.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.of((Object)new class_2588("text.rei.not.fully.initialized"));
    }

    @Override
    @Nullable
    public Tooltip provideTooltip(Point mouse) {
        return Tooltip.create(mouse, new class_2561[]{new class_2588("text.rei.not.fully.initialized.tooltip", new Object[]{this.notVisited().stream().map(Enum::name).collect(Collectors.joining(", "))})});
    }

    @Override
    public Color getColor() {
        return Color.ofTransparent((int)1358894336);
    }
}

