/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.DrawableConsumer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerErrorRenderer;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.client.gui.toast.CopyRecipeIdentifierToast;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.ArrowWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.BurningFireWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.ButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.DrawableWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.FillRectangleDrawableConsumer;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.LabelWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.PanelWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.TexturedDrawableConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public final class InternalWidgets {
    private InternalWidgets() {
    }

    public static Widget createAutoCraftingButtonWidget(Rectangle displayBounds, Rectangle rectangle, class_2561 text, Supplier<Display> displaySupplier, Supplier<Collection<class_2960>> idsSupplier, List<Widget> setupDisplay, DisplayCategory<?> category) {
        final class_465<?> containerScreen = REIRuntime.getInstance().getPreviousContainerScreen();
        MutableObject errorTooltip = new MutableObject(new ArrayList());
        final Button autoCraftingButton = Widgets.createButton(rectangle, text).focusable(false).onClick(button -> {
            TransferHandler.Context context = TransferHandler.Context.create(true, containerScreen, (Display)displaySupplier.get());
            for (TransferHandler autoTransferHandler : TransferHandlerRegistry.getInstance()) {
                try {
                    TransferHandler.Result result = autoTransferHandler.handle(context);
                    if (!result.isBlocking()) continue;
                    if (!result.isReturningToScreen()) {
                        return;
                    }
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            class_310.method_1551().method_1507((class_437)containerScreen);
            REIRuntime.getInstance().getOverlay().get().queueReloadOverlay();
        }).tooltipSupplier(arg_0 -> InternalWidgets.lambda$createAutoCraftingButtonWidget$1((Mutable)errorTooltip, idsSupplier, arg_0));
        return new DelegateWidget(autoCraftingButton, (Mutable)errorTooltip, displaySupplier, setupDisplay, displayBounds){
            boolean didJustRender;
            final /* synthetic */ Mutable val$errorTooltip;
            final /* synthetic */ Supplier val$displaySupplier;
            final /* synthetic */ List val$setupDisplay;
            final /* synthetic */ Rectangle val$displayBounds;
            {
                this.val$errorTooltip = mutable;
                this.val$displaySupplier = supplier;
                this.val$setupDisplay = list;
                this.val$displayBounds = rectangle;
                super(widget);
                this.didJustRender = false;
            }

            @Override
            public void method_25394(class_4587 poses, int mouseX, int mouseY, float delta) {
                this.didJustRender = false;
                autoCraftingButton.setEnabled(false);
                autoCraftingButton.setTint(0);
                if (containerScreen == null) {
                    this.val$errorTooltip.setValue((Object)Lists.newArrayList((Object[])new class_2561[]{new class_2588("error.rei.not.supported.move.items").method_27692(class_124.field_1061)}));
                    this.renderIf(false, poses, mouseX, mouseY, delta);
                    return;
                }
                ArrayList<TransferHandler.Result> errors = new ArrayList<TransferHandler.Result>();
                boolean hasApplicable = false;
                TransferHandlerErrorRenderer errorRenderer = null;
                TransferHandler.Context context = TransferHandler.Context.create(false, containerScreen, (Display)this.val$displaySupplier.get());
                for (TransferHandler transferHandler : TransferHandlerRegistry.getInstance()) {
                    try {
                        TransferHandler.Result result = transferHandler.handle(context);
                        if (!result.isApplicable()) continue;
                        hasApplicable = true;
                        autoCraftingButton.setTint(result.getColor());
                        if (result.isSuccessful()) {
                            errors.clear();
                            autoCraftingButton.setEnabled(true);
                            errorRenderer = null;
                            break;
                        }
                        errors.add(result);
                        TransferHandlerErrorRenderer transferHandlerErrorRenderer = result.getErrorRenderer(transferHandler, context);
                        if (transferHandlerErrorRenderer != null) {
                            errorRenderer = transferHandlerErrorRenderer;
                        }
                        if (!result.isBlocking()) continue;
                        break;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                if (!hasApplicable) {
                    this.val$errorTooltip.setValue((Object)Lists.newArrayList((Object[])new class_2561[]{new class_2588("error.rei.not.supported.move.items").method_27692(class_124.field_1061)}));
                    this.renderIf(false, poses, mouseX, mouseY, delta);
                    return;
                }
                if ((this.containsMouse(mouseX, mouseY) || autoCraftingButton.isFocused()) && errorRenderer != null) {
                    errorRenderer.render(poses, mouseX, mouseY, delta, this.val$setupDisplay, this.val$displayBounds, (Display)this.val$displaySupplier.get());
                }
                if (errors.isEmpty()) {
                    this.val$errorTooltip.setValue((Object)Lists.newArrayList((Object[])new class_2561[]{new class_2588("text.auto_craft.move_items")}));
                } else {
                    this.val$errorTooltip.setValue((Object)Lists.newArrayList());
                    ArrayList<class_2561> tooltipsFilled = new ArrayList<class_2561>();
                    for (TransferHandler.Result error : errors) {
                        error.fillTooltip(tooltipsFilled);
                    }
                    if (errors.size() == 1) {
                        for (class_2561 tooltipFilled : tooltipsFilled) {
                            colored = tooltipFilled.method_27661().method_27692(class_124.field_1061);
                            if (CollectionUtils.anyMatch((Iterable)this.val$errorTooltip.getValue(), ss -> ss.getString().equalsIgnoreCase(tooltipFilled.getString()))) continue;
                            ((List)this.val$errorTooltip.getValue()).add(colored);
                        }
                    } else {
                        ((List)this.val$errorTooltip.getValue()).add(new class_2588("error.rei.multi.errors").method_27692(class_124.field_1061));
                        for (class_2561 tooltipFilled : tooltipsFilled) {
                            colored = new class_2585("- ").method_27692(class_124.field_1061).method_10852((class_2561)tooltipFilled.method_27661().method_27692(class_124.field_1061));
                            if (CollectionUtils.anyMatch((Iterable)this.val$errorTooltip.getValue(), ss -> ss.getString().equalsIgnoreCase(colored.getString()))) continue;
                            ((List)this.val$errorTooltip.getValue()).add(colored);
                        }
                    }
                }
                this.renderIf(true, poses, mouseX, mouseY, delta);
            }

            private void renderIf(boolean should, class_4587 poseStack, int mouseX, int mouseY, float delta) {
                if (should) {
                    this.didJustRender = true;
                    this.widget.method_25394(poseStack, mouseX, mouseY, delta);
                } else if (class_310.method_1551().field_1690.field_1827) {
                    this.didJustRender = true;
                    this.widget.method_25394(poseStack, mouseX, mouseY, delta);
                }
            }

            public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                if (this.didJustRender && ((Display)this.val$displaySupplier.get()).getDisplayLocation().isPresent() && ConfigObject.getInstance().getCopyRecipeIdentifierKeybind().matchesKey(keyCode, scanCode) && this.containsMouse(PointHelper.ofMouse())) {
                    this.minecraft.field_1774.method_1455(((Display)this.val$displaySupplier.get()).getDisplayLocation().get().toString());
                    if (ConfigObject.getInstance().isToastDisplayedOnCopyIdentifier()) {
                        CopyRecipeIdentifierToast.addToast(class_1074.method_4662((String)"msg.rei.copied_recipe_id", (Object[])new Object[0]), class_1074.method_4662((String)"msg.rei.recipe_id_details", (Object[])new Object[]{((Display)this.val$displaySupplier.get()).getDisplayLocation().get().toString()}));
                    }
                    return true;
                }
                return super.method_25404(keyCode, scanCode, modifiers);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.didJustRender && ((Display)this.val$displaySupplier.get()).getDisplayLocation().isPresent() && ConfigObject.getInstance().getCopyRecipeIdentifierKeybind().matchesMouse(button) && this.containsMouse(PointHelper.ofMouse())) {
                    this.minecraft.field_1774.method_1455(((Display)this.val$displaySupplier.get()).getDisplayLocation().get().toString());
                    if (ConfigObject.getInstance().isToastDisplayedOnCopyIdentifier()) {
                        CopyRecipeIdentifierToast.addToast(class_1074.method_4662((String)"msg.rei.copied_recipe_id", (Object[])new Object[0]), class_1074.method_4662((String)"msg.rei.recipe_id_details", (Object[])new Object[]{((Display)this.val$displaySupplier.get()).getDisplayLocation().get().toString()}));
                    }
                    return true;
                }
                return super.method_25402(mouseX, mouseY, button);
            }
        };
    }

    public static WidgetWithBounds wrapLateRenderable(Widget widget) {
        return new LateRenderableWidget(widget);
    }

    public static Widget concatWidgets(Widget widget1, Widget widget2) {
        return new MergedWidget(widget2, widget1);
    }

    public static void attach() {
        ClientInternals.attachInstance(new WidgetsProvider(), ClientInternals.WidgetsProvider.class);
    }

    private static /* synthetic */ class_2561[] lambda$createAutoCraftingButtonWidget$1(Mutable errorTooltip, Supplier idsSupplier, Button button) {
        Collection locations;
        ArrayList<Object> str = new ArrayList<Object>((Collection)errorTooltip.getValue());
        if (class_310.method_1551().field_1690.field_1827 && !(locations = (Collection)idsSupplier.get()).isEmpty()) {
            str.add(new class_2585(" "));
            for (class_2960 location : locations) {
                String t = class_1074.method_4662((String)"text.rei.recipe_id", (Object[])new Object[]{"", location.toString()});
                if (t.startsWith("\n")) {
                    t = t.substring("\n".length());
                }
                str.add(new class_2585(t).method_27692(class_124.field_1080));
            }
        }
        return str.toArray(new class_2561[0]);
    }

    private static class LateRenderableWidget
    extends DelegateWidget
    implements LateRenderable {
        private LateRenderableWidget(Widget widget) {
            super(widget);
        }
    }

    private static class MergedWidget
    extends Widget {
        private final List<Widget> widgets;

        public MergedWidget(Widget widget1, Widget widget2) {
            this.widgets = Lists.newArrayList((Object[])new Widget[]{Objects.requireNonNull(widget1), Objects.requireNonNull(widget2)});
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            for (Widget widget : this.widgets) {
                widget.setZ(this.getZ());
                widget.method_25394(matrices, mouseX, mouseY, delta);
            }
        }

        public List<? extends class_364> method_25396() {
            return this.widgets;
        }

        public boolean method_25401(double mouseX, double mouseY, double amount) {
            for (Widget widget : this.widgets) {
                if (!widget.method_25401(mouseX, mouseY, amount)) continue;
                return true;
            }
            return false;
        }
    }

    private static class WidgetsProvider
    implements ClientInternals.WidgetsProvider {
        private WidgetsProvider() {
        }

        @Override
        public boolean isRenderingPanel(Panel panel) {
            return PanelWidget.isRendering(panel);
        }

        @Override
        public Widget createDrawableWidget(DrawableConsumer drawable) {
            return new DrawableWidget(drawable);
        }

        @Override
        public Slot createSlot(Point point) {
            return new EntryWidget(point);
        }

        @Override
        public Slot createSlot(Rectangle bounds) {
            return new EntryWidget(bounds);
        }

        @Override
        public Button createButton(Rectangle bounds, class_2561 text) {
            return new ButtonWidget(bounds, text);
        }

        @Override
        public Panel createPanelWidget(Rectangle bounds) {
            return new PanelWidget(bounds);
        }

        @Override
        public Label createLabel(Point point, class_5348 text) {
            return new LabelWidget(point, text);
        }

        @Override
        public Arrow createArrow(Rectangle rectangle) {
            return new ArrowWidget(rectangle);
        }

        @Override
        public BurningFire createBurningFire(Rectangle rectangle) {
            return new BurningFireWidget(rectangle);
        }

        @Override
        public DrawableConsumer createTexturedConsumer(class_2960 texture, int x, int y, int width, int height, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
            return new TexturedDrawableConsumer(texture, x, y, width, height, u, v, uWidth, vHeight, textureWidth, textureHeight);
        }

        @Override
        public DrawableConsumer createFillRectangleConsumer(Rectangle rectangle, int color) {
            return new FillRectangleDrawableConsumer(rectangle, color);
        }
    }
}

