/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.transfer;

import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerErrorRenderer;
import me.shedaniel.rei.api.common.display.Display;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_465;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public interface TransferHandler
extends Comparable<TransferHandler> {
    default public double getPriority() {
        return 0.0;
    }

    public Result handle(Context var1);

    @Override
    default public int compareTo(TransferHandler o) {
        return Double.compare(this.getPriority(), o.getPriority());
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    default public TransferHandlerErrorRenderer provideErrorRenderer(Context context, Object data) {
        return null;
    }

    @ApiStatus.Internal
    public static final class ContextImpl
    implements Context {
        private boolean actuallyCrafting;
        private class_465<?> containerScreen;
        private Supplier<Display> recipeDisplaySupplier;

        private ContextImpl(boolean actuallyCrafting, class_465<?> containerScreen, Supplier<Display> recipeDisplaySupplier) {
            this.actuallyCrafting = actuallyCrafting;
            this.containerScreen = containerScreen;
            this.recipeDisplaySupplier = recipeDisplaySupplier;
        }

        @Override
        public boolean isActuallyCrafting() {
            return this.actuallyCrafting;
        }

        @Override
        public class_465<?> getContainerScreen() {
            return this.containerScreen;
        }

        @Override
        public Display getDisplay() {
            return this.recipeDisplaySupplier.get();
        }
    }

    @ApiStatus.Internal
    public static final class ResultImpl
    implements Result {
        private boolean successful;
        private boolean applicable;
        private boolean returningToScreen;
        private boolean blocking;
        private class_2561 error;
        private Object errorRenderer;
        private int color;

        private ResultImpl() {
            this(true, true);
        }

        public ResultImpl(boolean applicable) {
            this(false, applicable);
        }

        public ResultImpl(boolean successful, boolean applicable) {
            this.successful = successful;
            this.applicable = applicable;
        }

        public ResultImpl(class_2561 error, int color) {
            this.successful = false;
            this.applicable = true;
            this.error = error;
            this.color = color;
        }

        @Override
        public Result blocksFurtherHandling(boolean returningToScreen) {
            this.blocking = true;
            this.returningToScreen = returningToScreen;
            return this;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public Result color(int color) {
            this.color = color;
            return this;
        }

        @Override
        public Result errorRenderer(Object data) {
            this.errorRenderer = data;
            return this;
        }

        @Override
        public boolean isSuccessful() {
            return this.successful;
        }

        @Override
        public boolean isBlocking() {
            return this.successful || this.blocking;
        }

        @Override
        public boolean isApplicable() {
            return this.applicable;
        }

        @Override
        public boolean isReturningToScreen() {
            return this.returningToScreen;
        }

        @Override
        public class_2561 getError() {
            return this.error;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public TransferHandlerErrorRenderer getErrorRenderer(TransferHandler handler, Context context) {
            if (this.errorRenderer == null) {
                return null;
            }
            return handler.provideErrorRenderer(context, this.errorRenderer);
        }

        @Override
        public void fillTooltip(List<class_2561> components) {
            if (!this.isSuccessful() && this.isApplicable()) {
                components.add(this.getError());
            }
        }
    }

    @ApiStatus.NonExtendable
    public static interface Context {
        public static Context create(boolean actuallyCrafting, @Nullable class_465<?> containerScreen, Display display) {
            return new ContextImpl(actuallyCrafting, containerScreen, () -> display);
        }

        default public class_310 getMinecraft() {
            return class_310.method_1551();
        }

        public boolean isActuallyCrafting();

        public Display getDisplay();

        @Nullable
        public class_465<?> getContainerScreen();

        @Nullable
        default public class_1703 getMenu() {
            return this.getContainerScreen() == null ? null : this.getContainerScreen().method_17577();
        }
    }

    @ApiStatus.NonExtendable
    public static interface Result {
        public static Result createSuccessful() {
            return new ResultImpl().color(0);
        }

        public static Result createNotApplicable() {
            return new ResultImpl(false).color(0);
        }

        public static Result createFailed(class_2561 error) {
            return new ResultImpl(error, 1744764928);
        }

        public static Result createFailedCustomButtonColor(class_2561 error, int color) {
            return Result.createFailed(error).color(color);
        }

        default public Result blocksFurtherHandling() {
            return this.blocksFurtherHandling(true);
        }

        public Result blocksFurtherHandling(boolean var1);

        public int getColor();

        public Result color(int var1);

        public Result errorRenderer(Object var1);

        public boolean isSuccessful();

        public boolean isBlocking();

        public boolean isReturningToScreen();

        public boolean isApplicable();

        public class_2561 getError();

        @Environment(value=EnvType.CLIENT)
        @ApiStatus.Internal
        public TransferHandlerErrorRenderer getErrorRenderer(TransferHandler var1, Context var2);

        @ApiStatus.Internal
        public void fillTooltip(List<class_2561> var1);
    }
}

