/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.utils;

import com.chaosthedude.naturescompass.config.NaturesCompassConfig;
import com.chaosthedude.naturescompass.workers.BiomeSearchWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.apache.commons.lang3.text.WordUtils;

public class BiomeUtils {
    public static class_2378<class_1959> getBiomeRegistry(class_1937 world) {
        return world.method_30349().method_30530(class_2378.field_25114);
    }

    public static class_2960 getIdentifierForBiome(class_1937 world, class_1959 biome) {
        return BiomeUtils.getBiomeRegistry(world).method_10221((Object)biome);
    }

    public static Optional<class_1959> getBiomeForIdentifier(class_1937 world, class_2960 id) {
        return BiomeUtils.getBiomeRegistry(world).method_17966(id);
    }

    public static List<class_2960> getAllowedBiomeIDs(class_1937 world) {
        ArrayList<class_2960> biomeIDs = new ArrayList<class_2960>();
        for (Map.Entry entry : BiomeUtils.getBiomeRegistry(world).method_29722()) {
            class_2960 biomeID;
            class_1959 biome = (class_1959)entry.getValue();
            if (biome == null || (biomeID = BiomeUtils.getIdentifierForBiome(world, biome)) == null || BiomeUtils.biomeIDIsBlacklisted(world, biomeID)) continue;
            biomeIDs.add(biomeID);
        }
        return biomeIDs;
    }

    public static void searchForBiome(class_1937 world, class_1657 player, class_1799 stack, class_1959 biome, class_2338 startPos) {
        BiomeSearchWorker worker = new BiomeSearchWorker(world, player, stack, biome, startPos);
        worker.start();
    }

    public static int getBiomeSize(class_1937 world) {
        return 4;
    }

    public static int getDistanceToBiome(class_1657 player, int biomeX, int biomeZ) {
        return BiomeUtils.getDistanceToBiome(player.method_24515(), biomeX, biomeZ);
    }

    public static int getDistanceToBiome(class_2338 startPos, int biomeX, int biomeZ) {
        return (int)class_3532.method_15355((float)((float)startPos.method_10262((class_2382)new class_2338(biomeX, startPos.method_10264(), biomeZ))));
    }

    @Environment(value=EnvType.CLIENT)
    public static String getBiomeCategoryName(class_1937 level, class_1959 biome) {
        String translatedCategoryKey;
        String translatedBiomeKey;
        String biomeKey = class_156.method_646((String)"biome", (class_2960)new class_2960(biome.method_8688().method_8749()));
        if (!biomeKey.equals(translatedBiomeKey = class_1074.method_4662((String)biomeKey, (Object[])new Object[0]))) {
            return translatedBiomeKey;
        }
        String categoryKey = class_156.method_646((String)"category", (class_2960)new class_2960(biome.method_8688().method_8749()));
        if (!categoryKey.equals(translatedCategoryKey = class_1074.method_4662((String)categoryKey, (Object[])new Object[0]))) {
            return translatedCategoryKey;
        }
        return WordUtils.capitalize((String)biome.method_8688().method_8749().replace('_', ' '));
    }

    @Environment(value=EnvType.CLIENT)
    public static String getBiomeNameForDisplay(class_1937 world, class_1959 biome) {
        if (biome != null) {
            if (NaturesCompassConfig.fixBiomeNames) {
                String original = BiomeUtils.getBiomeName(world, biome);
                Object fixed = "";
                char pre = ' ';
                for (int i = 0; i < original.length(); ++i) {
                    char c = original.charAt(i);
                    if (Character.isUpperCase(c) && Character.isLowerCase(pre) && Character.isAlphabetic(pre)) {
                        fixed = (String)fixed + " ";
                    }
                    fixed = (String)fixed + String.valueOf(c);
                    pre = c;
                }
                return fixed;
            }
            if (BiomeUtils.getIdentifierForBiome(world, biome) != null) {
                return class_1074.method_4662((String)BiomeUtils.getIdentifierForBiome(world, biome).toString(), (Object[])new Object[0]);
            }
        }
        return "";
    }

    @Environment(value=EnvType.CLIENT)
    public static String getBiomeName(class_1937 world, class_1959 biome) {
        return class_1074.method_4662((String)class_156.method_646((String)"biome", (class_2960)BiomeUtils.getIdentifierForBiome(world, biome)), (Object[])new Object[0]);
    }

    @Environment(value=EnvType.CLIENT)
    public static String getBiomeName(class_1937 world, class_2960 biomeID) {
        if (BiomeUtils.getBiomeForIdentifier(world, biomeID).isPresent()) {
            return BiomeUtils.getBiomeName(world, BiomeUtils.getBiomeForIdentifier(world, biomeID).get());
        }
        return "";
    }

    @Environment(value=EnvType.CLIENT)
    public static String getBiomeSource(class_1937 world, class_1959 biome) {
        String registryEntry = BiomeUtils.getIdentifierForBiome(world, biome).toString();
        String modid = registryEntry.substring(0, registryEntry.indexOf(":"));
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = FabricLoader.getInstance().getModContainer(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getMetadata().getName();
        }
        return modid;
    }

    public static boolean biomeIDIsBlacklisted(class_1937 world, class_2960 biomeID) {
        List<String> biomeBlacklist = NaturesCompassConfig.biomeBlacklist;
        for (String biomeKey : biomeBlacklist) {
            if (!biomeID.toString().matches(BiomeUtils.convertToRegex(biomeKey))) continue;
            return true;
        }
        return false;
    }

    private static String convertToRegex(String glob) {
        Object regex = "^";
        for (int i = 0; i < glob.length(); i = (int)((char)(i + 1))) {
            char c = glob.charAt(i);
            regex = c == '*' ? (String)regex + ".*" : (c == '?' ? (String)regex + "." : (c == '.' ? (String)regex + "\\." : (String)regex + c));
        }
        regex = (String)regex + "$";
        return regex;
    }
}

