/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.GlStateManager;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.accessor.SkullSettings;
import dev.tr7zw.skinlayers.render.CustomizableModelPart;
import dev.tr7zw.skinlayers.render.SolidPixelWrapper;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_591;
import net.minecraft.class_742;

public class SkinUtil {
    public static boolean hasCustomSkin(class_742 player) {
        return !class_1068.method_4648((UUID)player.method_5667()).equals((Object)player.method_3117());
    }

    private static class_1011 getSkinTexture(class_742 player) {
        return SkinUtil.getTexture(player.method_3117());
    }

    private static class_1011 getTexture(class_2960 resource) {
        class_1011 skin = new class_1011(class_1011.class_1012.field_4997, 64, 64, true);
        class_1060 textureManager = class_310.method_1551().method_1531();
        class_1044 abstractTexture = textureManager.method_4619(resource);
        if (abstractTexture == null) {
            return null;
        }
        GlStateManager._bindTexture((int)abstractTexture.method_4624());
        skin.method_4327(0, false);
        return skin;
    }

    public static boolean setup3dLayers(class_742 abstractClientPlayerEntity, PlayerSettings settings, boolean thinArms, class_591<class_742> model) {
        if (!SkinUtil.hasCustomSkin(abstractClientPlayerEntity)) {
            return false;
        }
        class_1011 skin = SkinUtil.getSkinTexture(abstractClientPlayerEntity);
        if (skin == null) {
            return false;
        }
        CustomizableModelPart[] layers = new CustomizableModelPart[5];
        layers[0] = SolidPixelWrapper.wrapBox(skin, 4, 12, 4, 0, 48, true, 0.0f);
        layers[1] = SolidPixelWrapper.wrapBox(skin, 4, 12, 4, 0, 32, true, 0.0f);
        if (thinArms) {
            layers[2] = SolidPixelWrapper.wrapBox(skin, 3, 12, 4, 48, 48, true, -2.5f);
            layers[3] = SolidPixelWrapper.wrapBox(skin, 3, 12, 4, 40, 32, true, -2.5f);
        } else {
            layers[2] = SolidPixelWrapper.wrapBox(skin, 4, 12, 4, 48, 48, true, -2.5f);
            layers[3] = SolidPixelWrapper.wrapBox(skin, 4, 12, 4, 40, 32, true, -2.5f);
        }
        layers[4] = SolidPixelWrapper.wrapBox(skin, 8, 12, 4, 16, 32, true, -0.8f);
        settings.setupSkinLayers(layers);
        settings.setupHeadLayers(SolidPixelWrapper.wrapBox(skin, 8, 8, 8, 32, 0, false, 0.6f));
        skin.close();
        return true;
    }

    public static boolean setup3dLayers(GameProfile gameprofile, SkullSettings settings) {
        if (gameprofile == null) {
            return false;
        }
        Map map = class_310.method_1551().method_1582().method_4654(gameprofile);
        MinecraftProfileTexture texture = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
        if (texture == null) {
            return false;
        }
        class_1011 skin = SkinUtil.getTexture(class_310.method_1551().method_1582().method_4656(texture, MinecraftProfileTexture.Type.SKIN));
        settings.setupHeadLayers(SolidPixelWrapper.wrapBox(skin, 8, 8, 8, 32, 0, false, 0.6f));
        skin.close();
        return true;
    }
}

