/*
 * Decompiled with CFR 0.152.
 */
package maroonshaded.gildedarmor.item;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import maroonshaded.gildedarmor.GildedArmor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1856;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public enum ModArmorMaterial implements class_1741
{
    GILDED_NETHERITE("gilded_netherite", (class_1741)class_1740.field_21977),
    GILDED_ENDERITE("gilded_enderite", 8, new int[]{4, 7, 9, 4}, 17, class_3417.field_21866, 4.0f, 0.1f, () -> class_1856.method_8106(GildedArmor.ENDERITE_INGOTS), true);

    private static final int[] BASE_DURABILITY;
    private static final int[] ENDERITE_BASE_DURABILITY;
    private final String name;
    private final ToIntFunction<class_1304> durability;
    private final ToIntFunction<class_1304> protectionAmount;
    private final int enchantability;
    private final class_3414 equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<class_1856> repairIngredientSupplier;

    private ModArmorMaterial(String name, int durabilityMultiplier, int[] protectionAmounts, int enchantability, class_3414 equipSound, float toughness, float knockbackResistance, Supplier<class_1856> repairIngredientSupplier, boolean useEnderiteDurability) {
        this.name = name;
        this.durability = slot -> (useEnderiteDurability ? ModArmorMaterial.getEnderiteBaseDurability() : ModArmorMaterial.getBaseDurability())[slot.method_5927()] * durabilityMultiplier;
        this.protectionAmount = slot -> protectionAmounts[slot.method_5927()];
        this.enchantability = enchantability;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredientSupplier = Suppliers.memoize(repairIngredientSupplier::get);
    }

    private ModArmorMaterial(String name, class_1741 reference) {
        this.name = name;
        this.durability = arg_0 -> ((class_1741)reference).method_7696(arg_0);
        this.protectionAmount = arg_0 -> ((class_1741)reference).method_7697(arg_0);
        this.enchantability = reference.method_7699();
        this.equipSound = reference.method_7698();
        this.toughness = reference.method_7700();
        this.knockbackResistance = reference.method_24355();
        this.repairIngredientSupplier = () -> ((class_1741)reference).method_7695();
    }

    public static int[] getBaseDurability() {
        return BASE_DURABILITY;
    }

    public static int[] getEnderiteBaseDurability() {
        return ENDERITE_BASE_DURABILITY;
    }

    public int method_7696(class_1304 slot) {
        return this.durability.applyAsInt(slot);
    }

    public int method_7697(class_1304 slot) {
        return this.protectionAmount.applyAsInt(slot);
    }

    public int method_7699() {
        return this.enchantability;
    }

    public class_3414 method_7698() {
        return this.equipSound;
    }

    public class_1856 method_7695() {
        return this.repairIngredientSupplier.get();
    }

    @Environment(value=EnvType.CLIENT)
    public String method_7694() {
        return this.name;
    }

    public float method_7700() {
        return this.toughness;
    }

    public float method_24355() {
        return this.knockbackResistance;
    }

    static {
        BASE_DURABILITY = new int[]{13, 15, 16, 11};
        ENDERITE_BASE_DURABILITY = new int[]{128, 144, 160, 112};
    }
}

